/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidGraph;

public interface Probability {
    public double getProbability(BoidGraph var1, Boid var2, int var3);

    public static class DeathProbability
    extends SigmoidProbability {
        public DeathProbability() {
            super(0.3, 80.0);
        }

        public DeathProbability(int averageLifeHopeness) {
            super(0.3, averageLifeHopeness);
        }

        public double getProbability(BoidGraph ctx, Boid b, int age) {
            return this.getSigmoidValue(age);
        }
    }

    public static abstract class SigmoidProbability
    implements Probability {
        double lambda = 1.0;
        double seuil = 0.0;

        public SigmoidProbability(double lambda, double seuil) {
            this.lambda = lambda;
            this.seuil = seuil;
        }

        protected double getSigmoidValue(double x) {
            return 1.0 / (1.0 + Math.exp(-this.lambda * (x - this.seuil)));
        }

        protected double getSigmoidValue(double x, double lambda, double seuil) {
            return 1.0 / (1.0 + Math.exp(-lambda * (x - seuil)));
        }
    }

    public static class ConstantProbability
    implements Probability {
        double p;

        public ConstantProbability(double p) {
            this.p = p;
        }

        public double getProbability(BoidGraph ctx, Boid b, int age) {
            return this.p;
        }
    }
}

