/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidGraph;
import org.graphstream.boids.DemographicManager;
import org.graphstream.boids.Probability;
import org.graphstream.graph.implementations.AbstractGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoidSpecies
implements Iterable<Boid> {
    protected BoidGraph ctx;
    protected final String name;
    protected double viewZone;
    protected double angleOfView;
    protected double speedFactor;
    protected double maxSpeed;
    protected double minSpeed;
    protected double directionFactor;
    protected double attractionFactor;
    protected double repulsionFactor;
    protected double inertia;
    protected double fearFactor;
    protected Color color = new Color(1, 0, 0);
    protected HashMap<String, Boid> boids;
    protected boolean addSpeciesNameInUIClass;
    protected int currentIndex = 0;
    protected long timestamp = System.nanoTime();
    protected DemographicManager pop;

    public BoidSpecies(BoidGraph ctx, String name) {
        this.boids = new HashMap();
        this.ctx = ctx;
        this.name = name;
        this.angleOfView = 0.0;
        this.viewZone = 0.15f;
        this.speedFactor = 0.3f;
        this.maxSpeed = 1.0;
        this.minSpeed = 0.04f;
        this.directionFactor = 0.1f;
        this.attractionFactor = 0.5;
        this.repulsionFactor = 0.001f;
        this.inertia = 1.1f;
        this.fearFactor = 1.0;
        this.addSpeciesNameInUIClass = true;
        this.pop = new DemographicManager.SpeciesDemographicManager(this, ctx, new Probability.ConstantProbability(0.01), new Probability.ConstantProbability(0.01));
        this.color = new Color(ctx.random.nextFloat(), ctx.random.nextFloat(), ctx.random.nextFloat());
    }

    public String getName() {
        return this.name;
    }

    public void set(String p, String val) throws IllegalArgumentException {
        Parameter param = Parameter.valueOf(p.toUpperCase());
        this.set(param, val);
    }

    public void set(Parameter p, String val) {
        if (BoidGraph.VERBOSE) {
            System.out.printf("set %s of %s to %s\n", p.name(), this.name, val);
        }
        switch (p) {
            case COUNT: {
                this.setCount(Integer.parseInt(val));
                break;
            }
            case VIEW_ZONE: {
                this.viewZone = Double.parseDouble(val);
                break;
            }
            case SPEED_FACTOR: {
                this.speedFactor = Double.parseDouble(val);
                break;
            }
            case MAX_SPEED: {
                this.maxSpeed = Double.parseDouble(val);
                break;
            }
            case MIN_SPEED: {
                this.minSpeed = Double.parseDouble(val);
                break;
            }
            case DIRECTION_FACTOR: {
                this.directionFactor = Double.parseDouble(val);
                break;
            }
            case ATTRACTION_FACTOR: {
                this.attractionFactor = Double.parseDouble(val);
                break;
            }
            case REPULSION_FACTOR: {
                this.repulsionFactor = Double.parseDouble(val);
                break;
            }
            case INERTIA: {
                this.inertia = Double.parseDouble(val);
                break;
            }
            case FEAR_FACTOR: {
                this.fearFactor = Double.parseDouble(val);
                break;
            }
            case ANGLE_OF_VIEW: {
                this.angleOfView = Double.parseDouble(val);
                break;
            }
            case ADD_SPECIES_NAME_IN_UI_CLASS: {
                this.addSpeciesNameInUIClass = Boolean.parseBoolean(val);
            }
        }
    }

    public String createNewId() {
        return String.format("%s.%x_%x", this.name, this.timestamp, this.currentIndex++);
    }

    public Boid createBoid() {
        return this.createBoid(this.createNewId());
    }

    public Boid createBoid(String id) {
        return new Boid((AbstractGraph)this.ctx, this, id);
    }

    void register(Boid b) {
        this.boids.put(b.getId(), b);
    }

    void checkClasses(Boid b) {
        if (this.addSpeciesNameInUIClass) {
            String uiClass = (String)b.getAttribute("ui.class");
            uiClass = uiClass == null ? this.name : uiClass + " " + this.name;
            b.setAttribute("ui.class", new Object[]{uiClass});
        }
    }

    void unregister(Boid b) {
        this.boids.remove(b.getId());
    }

    public void terminateStep(double time) {
        this.pop.step(time);
    }

    public int getPopulation() {
        return this.boids.size();
    }

    public void setCount(int count) {
        while (this.boids.size() < count) {
            this.ctx.addNode(this.createNewId());
        }
    }

    public double getViewZone() {
        return this.viewZone;
    }

    public void setViewZone(double viewZone) {
        this.viewZone = viewZone;
    }

    public double getSpeedFactor() {
        return this.speedFactor;
    }

    public void setSpeedFactor(double speedFactor) {
        this.speedFactor = speedFactor;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public double getMinSpeed() {
        return this.minSpeed;
    }

    public void setMinSpeed(double minSpeed) {
        this.minSpeed = minSpeed;
    }

    public double getDirectionFactor() {
        return this.directionFactor;
    }

    public void setDirectionFactor(double directionFactor) {
        this.directionFactor = directionFactor;
    }

    public double getAttractionFactor() {
        return this.attractionFactor;
    }

    public void setAttractionFactor(double attractionFactor) {
        this.attractionFactor = attractionFactor;
    }

    public double getRepulsionFactor() {
        return this.repulsionFactor;
    }

    public void setRepulsionFactor(double repulsionFactor) {
        this.repulsionFactor = repulsionFactor;
    }

    public double getInertia() {
        return this.inertia;
    }

    public void setInertia(double inertia) {
        this.inertia = inertia;
    }

    public double getFearFactor() {
        return this.fearFactor;
    }

    public void setFearFactor(double fearFactor) {
        this.fearFactor = fearFactor;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getAngleOfView() {
        return this.angleOfView;
    }

    public void setAngleOfView(double aov) {
        this.angleOfView = aov;
    }

    public void setReproductionProbability(Probability probability) {
        this.pop.setReproduceCondition(probability);
    }

    public void setDeathCondition(Probability probability) {
        this.pop.setDeathProbability(probability);
    }

    public void release() {
        this.pop.release();
        Iterator i = this.ctx.getNodeIterator();
        while (i.hasNext()) {
            Boid b = (Boid)((Object)i.next());
            if (b.getSpecies() != this) continue;
            i.remove();
        }
    }

    @Override
    public Iterator<Boid> iterator() {
        return this.boids.values().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        COUNT,
        ANGLE_OF_VIEW,
        VIEW_ZONE,
        SPEED_FACTOR,
        MAX_SPEED,
        MIN_SPEED,
        DIRECTION_FACTOR,
        ATTRACTION_FACTOR,
        REPULSION_FACTOR,
        INERTIA,
        FEAR_FACTOR,
        ADD_SPECIES_NAME_IN_UI_CLASS;

    }
}

