/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidForces;
import org.graphstream.boids.BoidForcesFactory;
import org.graphstream.boids.BoidGraphListener;
import org.graphstream.boids.BoidSpecies;
import org.graphstream.boids.forces.ntree.NTreeForcesFactory;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.ui.swingViewer.Viewer;
import org.graphstream.ui.swingViewer.util.Camera;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.geom.Vector3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoidGraph
extends AdjacencyListGraph {
    public static boolean VERBOSE = Boolean.parseBoolean(System.getProperty("boids.verbose", "true"));
    protected int maxSteps;
    protected double area;
    protected int sleepTime;
    protected boolean storeForcesAttributes;
    protected boolean normalizeMode;
    protected long randomSeed;
    protected HashMap<String, BoidSpecies> boidSpecies;
    protected boolean loop;
    protected int step;
    protected Random random;
    protected BoidForcesFactory forcesFactory;
    protected Point3 lowAnchor;
    protected Point3 highAnchor;
    protected ArrayList<BoidGraphListener> listeners = new ArrayList();

    public BoidGraph() {
        super("boids-context");
        this.setNodeFactory(new BoidFactory());
        this.random = new Random();
        this.randomSeed = this.random.nextLong();
        this.random = new Random(this.randomSeed);
        this.lowAnchor = new Point3(-1.0, -1.0, -1.0);
        this.highAnchor = new Point3(1.0, 1.0, 1.0);
        this.loop = false;
        this.normalizeMode = true;
        this.storeForcesAttributes = false;
        this.sleepTime = 20;
        this.area = 1.0;
        this.maxSteps = 0;
        this.boidSpecies = new HashMap();
        this.setForcesFactory(new NTreeForcesFactory(this));
    }

    public BoidGraph(String dgsConfig) throws IOException {
        this();
        this.loadDGSConfiguration(dgsConfig);
    }

    public void loadDGSConfiguration(String dgs) throws IOException {
        InputStream in;
        block3: {
            try {
                in = new FileInputStream(dgs);
            }
            catch (FileNotFoundException e) {
                in = ((Object)((Object)this)).getClass().getResourceAsStream(dgs);
                if (in == null) {
                    in = ClassLoader.getSystemResourceAsStream(dgs);
                }
                if (in != null) break block3;
                throw e;
            }
        }
        this.loadDGSConfiguration(in);
        in.close();
    }

    public void loadDGSConfiguration(InputStream in) throws IOException {
        FileSourceDGS config = new FileSourceDGS();
        config.addSink((Sink)this);
        config.readAll(in);
        config.removeSink((Sink)this);
    }

    public void setForcesFactory(BoidForcesFactory bff) {
        if (this.forcesFactory != null) {
            this.forcesFactory.end();
        }
        this.forcesFactory = bff;
        for (Boid b : this.getEachNode()) {
            Point3 p = b.getPosition();
            Vector3 d = b.getForces().getDirection();
            b.setForces(bff.createNewForces(b));
            b.setPosition(p.x, p.y, p.z);
            b.getForces().getDirection().copy(d);
        }
        this.forcesFactory.init();
        if (VERBOSE) {
            System.out.printf("forces factory is now %s\n", bff.getClass().getName());
        }
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
        this.lowAnchor.set(-area, -area, -area);
        this.highAnchor.set(area, area, area);
        this.forcesFactory.resize(this.lowAnchor, this.highAnchor);
    }

    public Point3 getLowAnchor() {
        return this.lowAnchor;
    }

    public Point3 getHighAnchor() {
        return this.highAnchor;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
        this.random = new Random(randomSeed);
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public boolean isNormalizeMode() {
        return this.normalizeMode;
    }

    public void setNormalizeMode(boolean on) {
        this.normalizeMode = on;
    }

    public boolean isForcesAttributesStored() {
        return this.storeForcesAttributes;
    }

    public void setStoreForcesAttributes(boolean storeForcesAttributes) {
        this.storeForcesAttributes = storeForcesAttributes;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    public Random getRandom() {
        return this.random;
    }

    public BoidSpecies getOrCreateSpecies(String name) {
        return this.getOrCreateSpecies(name, null);
    }

    public BoidSpecies getOrCreateSpecies(String name, String clazz) {
        BoidSpecies species = this.boidSpecies.get(name);
        if (species == null) {
            if (clazz == null) {
                species = new BoidSpecies(this, name);
            } else {
                try {
                    Class<?> classObj = Class.forName(clazz);
                    Object obj = classObj.getConstructor(BoidGraph.class, String.class).newInstance(new Object[]{this, name});
                    if (!(obj instanceof BoidSpecies)) {
                        String msg = String.format("not a species class : '%s'", clazz);
                        throw new RuntimeException(msg);
                    }
                    species = (BoidSpecies)obj;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            this.boidSpecies.put(name, species);
            if (VERBOSE) {
                System.out.printf("new species : %s\n", name);
            }
        }
        return species;
    }

    public BoidSpecies getSpecies(String name) {
        return this.boidSpecies.get(name);
    }

    public int getSpeciesCount() {
        return this.boidSpecies.size();
    }

    public BoidSpecies getDefaultSpecies() {
        return this.getSpecies("default");
    }

    public BoidSpecies addDefaultSpecies() {
        return this.getOrCreateSpecies("default");
    }

    public void deleteSpecies(String name) {
        BoidSpecies species;
        if (!name.equals("default") && (species = this.boidSpecies.get(name)) != null) {
            species.release();
            this.boidSpecies.remove(name);
        }
    }

    public void set(String paramName, String value) throws IllegalArgumentException {
        Parameter param = Parameter.valueOf(paramName.toUpperCase());
        this.set(param, value);
    }

    public void set(Parameter param, String value) {
        switch (param) {
            case MAX_STEPS: {
                this.setMaxSteps(Integer.parseInt(value));
                break;
            }
            case AREA: {
                this.setArea(Float.parseFloat(value));
                break;
            }
            case SLEEP_TIME: {
                this.setSleepTime(Integer.parseInt(value));
                break;
            }
            case STORE_FORCES_ATTRIBUTES: {
                this.setStoreForcesAttributes(Boolean.parseBoolean(value));
                break;
            }
            case NORMALIZE_MODE: {
                this.setNormalizeMode(Boolean.parseBoolean(value));
                break;
            }
            case RANDOM_SEED: {
                this.setRandomSeed(Long.parseLong(value));
                break;
            }
            case FORCES_FACTORY: {
                Class<?> ffClass;
                Object obj = null;
                try {
                    ffClass = Class.forName(value);
                }
                catch (ClassNotFoundException e) {
                    System.err.printf("ForcesFactory class '%s' not found\n", value);
                    return;
                }
                try {
                    Constructor<?> c = ffClass.getConstructor(BoidGraph.class);
                    obj = c.newInstance(new Object[]{this});
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    System.err.printf("no constructor %s(BoidGraph) found.\n", value);
                    System.err.printf("try to use default constructor.\n", new Object[0]);
                    try {
                        obj = ffClass.newInstance();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (obj == null) {
                    System.err.printf("unable to create a %s forces factory\n", value);
                    return;
                }
                if (obj instanceof BoidForcesFactory) {
                    this.setForcesFactory(obj);
                    break;
                }
                System.err.printf("%s is not a forces factory\n", value);
            }
        }
    }

    public void stopLoop() {
        this.loop = false;
    }

    public void loop() {
        this.loop = true;
        while (this.loop) {
            this.step();
            if (this.maxSteps > 0 && this.step > this.maxSteps) {
                this.loop = false;
            }
            this.sleep(this.sleepTime);
        }
    }

    public void step() {
        ++this.step;
        this.stepBegins(this.step);
    }

    public void stepBegins(double step) {
        for (BoidSpecies sp : this.boidSpecies.values()) {
            sp.terminateStep(step);
        }
        for (BoidGraphListener listener : this.listeners) {
            listener.step(step);
        }
        this.forcesFactory.step();
        super.stepBegins(step);
    }

    public boolean isLooping() {
        return this.loop;
    }

    public Viewer display(boolean autoLayout) {
        Viewer v = super.display(autoLayout);
        Camera cam = v.getDefaultView().getCamera();
        cam.setGraphViewport(-this.area, -this.area, this.area, this.area);
        return v;
    }

    protected void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addBoidGraphListener(BoidGraphListener listener) {
        this.listeners.add(listener);
    }

    public void removeBoidGraphListener(BoidGraphListener listener) {
        int index = this.listeners.indexOf(listener);
        if (index >= 0) {
            this.listeners.remove(index);
        }
    }

    public <T extends Node> T addNode(String nodeId) {
        Node n = super.addNode(nodeId);
        Boid b = (Boid)n;
        b.getSpecies().checkClasses(b);
        for (BoidGraphListener listener : this.listeners) {
            listener.boidAdded(b);
        }
        return (T)n;
    }

    protected void addNodeCallback(AbstractNode node) {
        Boid b = (Boid)node;
        super.addNodeCallback(node);
        b.getSpecies().register(b);
    }

    protected void removeNodeCallback(AbstractNode node) {
        Boid b = (Boid)node;
        b.getSpecies().unregister(b);
        super.removeNodeCallback(node);
        for (BoidGraphListener listener : this.listeners) {
            listener.boidDeleted(b);
        }
    }

    protected void attributeChanged(String sourceId, long timeId, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        String key = attribute;
        if (key.startsWith("boids.")) {
            if ((key = key.substring("boids.".length())).startsWith("species.")) {
                String name;
                if ((key = key.substring("species.".length())).indexOf(46) > 0) {
                    name = key.substring(0, key.indexOf(46));
                    key = key.substring(name.length() + 1);
                } else {
                    name = key;
                    key = null;
                }
                switch (event) {
                    case REMOVE: {
                        if (!this.boidSpecies.containsKey(name)) break;
                        this.deleteSpecies(name);
                        break;
                    }
                    case ADD: 
                    case CHANGE: {
                        BoidSpecies species = key == null && newValue != null && newValue instanceof String ? this.getOrCreateSpecies(name, (String)newValue) : this.getOrCreateSpecies(name);
                        if (key == null) break;
                        try {
                            species.set(key, newValue == null ? null : newValue.toString());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            System.err.printf("(WW) invalid parameter '%s'\n", key);
                            System.err.printf("     ignoring it.\n", new Object[0]);
                        }
                    }
                }
            } else {
                this.set(key, newValue == null ? null : newValue.toString());
            }
        }
        super.attributeChanged(sourceId, timeId, attribute, event, oldValue, newValue);
    }

    public static void main(String ... args) {
        BoidGraph ctx = new BoidGraph();
        try {
            ctx.loadDGSConfiguration(BoidGraph.class.getResourceAsStream("configExampleWithTwoSpecies.dgs"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ctx.display(false);
        ctx.loop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BoidFactory
    implements NodeFactory<Boid> {
        private BoidFactory() {
        }

        public Boid newInstance(String id, Graph graph) {
            BoidSpecies species = null;
            if (id.indexOf(46) != -1) {
                species = BoidGraph.this.boidSpecies.get(id.substring(0, id.indexOf(46)));
            }
            if (species == null) {
                species = BoidGraph.this.getDefaultSpecies();
            }
            Boid b = species.createBoid(id);
            BoidForces f = BoidGraph.this.forcesFactory.createNewForces(b);
            b.setForces(f);
            return b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter {
        MAX_STEPS,
        AREA,
        SLEEP_TIME,
        STORE_FORCES_ATTRIBUTES,
        NORMALIZE_MODE,
        RANDOM_SEED,
        FORCES_FACTORY;

    }
}

