/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import java.util.Collection;
import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidGraph;
import org.graphstream.boids.BoidSpecies;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.geom.Vector3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BoidForces {
    public Point3 barycenter = new Point3();
    public Vector3 direction = new Vector3();
    public Vector3 attraction = new Vector3();
    public Vector3 repulsion = new Vector3();
    public int countAtt = 0;
    public int countRep = 0;
    protected Boid boid;
    protected Vector3 dir;

    public BoidForces(Boid b) {
        this.boid = b;
        this.dir = new Vector3(((BoidGraph)b.getGraph()).getRandom().nextDouble(), ((BoidGraph)b.getGraph()).getRandom().nextDouble(), 0.0);
    }

    public void compute() {
        BoidSpecies species = this.boid.getSpecies();
        Vector3 dir = this.getDirection();
        Vector3 rep = new Vector3();
        Point3 nextPos = this.getNextPosition();
        this.barycenter.set(0.0, 0.0, 0.0);
        this.direction.fill(0.0);
        this.attraction.fill(0.0);
        this.repulsion.fill(0.0);
        this.countAtt = 0;
        this.countRep = 0;
        Collection<Boid> neigh = this.getNeighborhood();
        for (Boid b : neigh) {
            this.actionWithNeighboor(b, rep);
        }
        this.boid.checkNeighborhood(neigh.toArray(new Boid[neigh.size()]));
        if (this.countAtt > 0) {
            this.barycenter.scale((double)(1.0f / (float)this.countAtt), (double)(1.0f / (float)this.countAtt), (double)(1.0f / (float)this.countAtt));
            this.direction.scalarDiv((double)this.countAtt);
            this.attraction.set(this.barycenter.x - this.boid.getPosition().x, this.barycenter.y - this.boid.getPosition().y, this.barycenter.z - this.boid.getPosition().z);
        }
        if (this.countRep > 0) {
            this.repulsion.scalarDiv((double)this.countRep);
        }
        this.direction.scalarMult(species.getDirectionFactor());
        this.attraction.scalarMult(species.getAttractionFactor());
        this.repulsion.scalarMult(species.getRepulsionFactor());
        dir.scalarMult(species.getInertia());
        dir.add(this.direction);
        dir.add(this.attraction);
        dir.add(this.repulsion);
        if (((BoidGraph)this.boid.getGraph()).isNormalizeMode()) {
            double len = dir.normalize();
            if (len <= species.getMinSpeed()) {
                len = species.getMinSpeed();
            } else if (len >= species.getMaxSpeed()) {
                len = species.getMaxSpeed();
            }
            dir.scalarMult(species.getSpeedFactor() * len);
        } else {
            dir.scalarMult(species.getSpeedFactor());
        }
        this.checkWalls();
        nextPos.move(dir);
        this.boid.setAttribute("xyz", new Object[]{nextPos.x, nextPos.y, nextPos.z});
    }

    public void addRepulsion(Vector3 rep) {
        this.repulsion.add(rep);
        ++this.countRep;
    }

    public void addDirection(Vector3 dir) {
        this.direction.add(dir);
        ++this.countAtt;
    }

    public void addAttraction(Vector3 att) {
        this.attraction.add(att);
        ++this.countAtt;
    }

    public void moveBarycenter(Point3 p) {
        this.barycenter.move(p);
    }

    protected void actionWithNeighboor(Boid b, Vector3 rep) {
        Point3 p1 = this.boid.getPosition();
        Point3 p2 = b.getPosition();
        BoidSpecies p1Species = this.boid.getSpecies();
        BoidSpecies p2Species = b.getSpecies();
        double v = this.boid.getSpecies().getViewZone();
        rep.set(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
        double len = rep.length();
        if (len != 0.0) {
            if (p1Species != p2Species) {
                rep.scalarMult(1.0 / (len * len) * p2Species.getFearFactor());
            } else {
                rep.scalarMult(1.0 / (len * len));
            }
        }
        double a = Math.log(Math.min(len, v)) / Math.log(v);
        rep.scalarMult(a);
        this.repulsion.add(rep);
        ++this.countRep;
        if (p1Species == p2Species) {
            this.barycenter.move(p2);
            this.direction.add(b.getForces().getDirection());
            ++this.countAtt;
        }
    }

    protected void checkWalls() {
        float aarea = 1.0E-6f;
        Point3 lo = ((BoidGraph)this.boid.getGraph()).getLowAnchor();
        Point3 hi = ((BoidGraph)this.boid.getGraph()).getHighAnchor();
        Point3 nextPos = this.getNextPosition();
        if (nextPos.x + this.dir.data[0] <= lo.x + (double)aarea) {
            nextPos.x = lo.x + (double)aarea;
            this.dir.data[0] = -this.dir.data[0];
        } else if (nextPos.x + this.dir.data[0] >= hi.x - (double)aarea) {
            nextPos.x = hi.x - (double)aarea;
            this.dir.data[0] = -this.dir.data[0];
        }
        if (nextPos.y + this.dir.data[1] <= lo.y + (double)aarea) {
            nextPos.y = lo.y + (double)aarea;
            this.dir.data[1] = -this.dir.data[1];
        } else if (nextPos.y + this.dir.data[1] >= hi.y - (double)aarea) {
            nextPos.y = hi.y - (double)aarea;
            this.dir.data[1] = -this.dir.data[1];
        }
        if (nextPos.z + this.dir.data[2] <= lo.z + (double)aarea) {
            nextPos.z = lo.z + (double)aarea;
            this.dir.data[2] = -this.dir.data[2];
        } else if (nextPos.z + this.dir.data[2] >= hi.z - (double)aarea) {
            nextPos.z = hi.z - (double)aarea;
            this.dir.data[2] = -this.dir.data[2];
        }
    }

    public boolean isVisible(Boid boid, Point3 point) {
        BoidSpecies species = boid.getSpecies();
        Point3 pos = boid.getPosition();
        double d = pos.distance(point);
        if (d <= species.getViewZone()) {
            if (species.getAngleOfView() > -1.0) {
                Vector3 dir = new Vector3(boid.getForces().getDirection());
                Vector3 light = new Vector3(point.x - pos.x, point.y - pos.y, point.z - pos.z);
                dir.normalize();
                light.normalize();
                double angle = dir.dotProduct(light);
                if (angle > species.getAngleOfView()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public Vector3 getDirection() {
        return this.dir;
    }

    public abstract void setPosition(double var1, double var3, double var5);

    public abstract Point3 getPosition();

    public abstract Point3 getNextPosition();

    public abstract Collection<Boid> getNeighborhood();
}

