/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import java.util.Iterator;
import java.util.LinkedList;
import org.graphstream.boids.BoidForces;
import org.graphstream.boids.BoidSpecies;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AdjacencyListNode;
import org.miv.pherd.geom.Point3;

public class Boid
extends AdjacencyListNode {
    protected final BoidSpecies species;
    protected BoidForces forces;

    public Boid(AbstractGraph graph, BoidSpecies species, String id) {
        super(graph, id);
        this.species = species;
        this.forces = null;
    }

    public void setPosition(double x, double y, double z) {
        this.forces.setPosition(x, y, z);
    }

    public Point3 getPosition() {
        return this.forces.getPosition();
    }

    public BoidSpecies getSpecies() {
        return this.species;
    }

    public void setForces(BoidForces forces) {
        this.forces = forces;
    }

    public BoidForces getForces() {
        return this.forces;
    }

    public void checkNeighborhood(Boid ... boids) {
        if (this.getGraph().getNode(this.getId()) == null) {
            System.err.printf("I do not exist any more !!!%n", new Object[0]);
            return;
        }
        if (boids != null) {
            Iterator it = this.getNeighborNodeIterator();
            LinkedList<Boid> toRemove = null;
            while (it.hasNext()) {
                boolean found = false;
                Boid b = (Boid)((Object)it.next());
                for (Boid b2 : boids) {
                    if (b != b2) continue;
                    found = true;
                    break;
                }
                if (found || this.forces.isVisible(b, this.getPosition())) continue;
                if (toRemove == null) {
                    toRemove = new LinkedList<Boid>();
                }
                toRemove.add(b);
            }
            if (toRemove != null) {
                for (Boid b : toRemove) {
                    this.getGraph().removeEdge(Boid.getEdgeId(this, b));
                }
                toRemove.clear();
                toRemove = null;
            }
            for (Boid b2 : boids) {
                if (this.getEdgeBetween((Node)b2) != null) continue;
                if (this.getGraph().getNode(b2.getId()) != null) {
                    this.getGraph().addEdge(Boid.getEdgeId(this, b2), (Node)this, (Node)b2);
                    continue;
                }
                System.err.printf("%s does not exists !!%n", b2.getId());
            }
        } else {
            while (this.getDegree() > 0) {
                this.getGraph().removeEdge(this.getEdge(0));
            }
        }
    }

    public static final String getEdgeId(Boid b1, Boid b2) {
        if (((Object)((Object)b1)).hashCode() > ((Object)((Object)b2)).hashCode()) {
            Boid t = b1;
            b1 = b2;
            b2 = t;
        }
        return String.format("%s--%s", b1.getId(), b2.getId());
    }
}

