/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.io.IOUtils;
import grails.util.CacheEntry;
import grails.util.Environment;
import grails.util.GrailsUtil;
import grails.util.Holders;
import groovy.lang.GroovyClassLoader;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.grails.core.exceptions.DefaultErrorsPrinter;
import org.grails.exceptions.ExceptionUtils;
import org.grails.gsp.GroovyPageClassLoader;
import org.grails.gsp.GroovyPageMetaInfo;
import org.grails.gsp.GroovyPageSourceDecorator;
import org.grails.gsp.GroovyPageTemplate;
import org.grails.gsp.GroovyPagesException;
import org.grails.gsp.GroovyPagesMetaUtils;
import org.grails.gsp.ResourceAwareTemplateEngine;
import org.grails.gsp.compiler.GroovyPageParser;
import org.grails.gsp.io.DefaultGroovyPageLocator;
import org.grails.gsp.io.GroovyPageCompiledScriptSource;
import org.grails.gsp.io.GroovyPageLocator;
import org.grails.gsp.io.GroovyPageResourceScriptSource;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.gsp.jsp.TagLibraryResolver;
import org.grails.taglib.TagLibraryLookup;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.util.Assert;

public class GroovyPagesTemplateEngine
extends ResourceAwareTemplateEngine
implements ResourceLoaderAware,
ApplicationContextAware,
InitializingBean,
BeanClassLoaderAware {
    public static final String CONFIG_PROPERTY_DISABLE_CACHING_RESOURCES = "grails.gsp.disable.caching.resources";
    public static final String CONFIG_PROPERTY_GSP_ENABLE_RELOAD = "grails.gsp.enable.reload";
    public static final String BEAN_ID = "groovyPagesTemplateEngine";
    private static final String GENERATED_GSP_NAME_PREFIX = "gsp_script_";
    private static final Log LOG;
    private static File dumpLineNumbersTo;
    private ConcurrentMap<String, CacheEntry<GroovyPageMetaInfo>> pageCache = new ConcurrentHashMap<String, CacheEntry<GroovyPageMetaInfo>>();
    private ClassLoader classLoader;
    private AtomicInteger scriptNameCount = new AtomicInteger(0);
    private GroovyPageLocator groovyPageLocator = new DefaultGroovyPageLocator();
    private boolean reloadEnabled;
    private TagLibraryLookup tagLibraryLookup;
    private TagLibraryResolver jspTagLibraryResolver;
    private boolean cacheResources = true;
    private GrailsApplication grailsApplication;
    private Map<String, Class<?>> cachedDomainsWithoutPackage;
    private List<GroovyPageSourceDecorator> groovyPageSourceDecorators = new ArrayList<GroovyPageSourceDecorator>();

    public void setGroovyPageSourceDecorators(List<GroovyPageSourceDecorator> groovyPageSourceDecorators) {
        this.groovyPageSourceDecorators = groovyPageSourceDecorators;
    }

    public List<GroovyPageSourceDecorator> getGroovyPageSourceDecorators() {
        return this.groovyPageSourceDecorators;
    }

    public void setGroovyPageLocator(GroovyPageLocator groovyPageLocator) {
        this.groovyPageLocator = groovyPageLocator;
    }

    public GroovyPageLocator getGroovyPageLocator() {
        return this.groovyPageLocator;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.groovyPageLocator.addResourceLoader(resourceLoader);
    }

    public void afterPropertiesSet() {
        if (this.classLoader == null) {
            this.classLoader = this.initGroovyClassLoader(Thread.currentThread().getContextClassLoader());
        } else if (!this.classLoader.getClass().equals(GroovyPageClassLoader.class)) {
            this.classLoader = this.initGroovyClassLoader(this.classLoader);
        }
        if (!Environment.isDevelopmentMode()) {
            this.cachedDomainsWithoutPackage = this.createDomainClassMap();
        }
    }

    private GroovyClassLoader initGroovyClassLoader(ClassLoader parent) {
        CompilerConfiguration compConfig = new CompilerConfiguration();
        compConfig.setSourceEncoding("UTF-8");
        return new GroovyPageClassLoader(parent, compConfig);
    }

    public void setTagLibraryLookup(TagLibraryLookup tagLibraryLookup) {
        this.tagLibraryLookup = tagLibraryLookup;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int[] calculateLineNumbersForPage(String url) {
        try {
            Template t = this.createTemplate(url);
            if (t instanceof GroovyPageTemplate) {
                return ((GroovyPageTemplate)t).getMetaInfo().getLineNumbers();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception retrieving line numbers from GSP: " + url + ", message: " + e.getMessage()));
            LOG.debug((Object)"Full stack trace of error", (Throwable)e);
        }
        return new int[0];
    }

    @Override
    public int mapStackLineNumber(String url, int lineNumber) {
        int[] lineNumbers = this.calculateLineNumbersForPage(url);
        if (lineNumber < lineNumbers.length) {
            lineNumber = lineNumbers[lineNumber - 1];
        }
        return lineNumber;
    }

    @Override
    public Template createTemplate(Resource resource) {
        return this.createTemplate(resource, this.cacheResources);
    }

    @Override
    public Template createTemplate(Resource resource, boolean cacheable) {
        if (resource == null) {
            throw new GroovyPagesException("Resource is null. No Groovy page found.");
        }
        String pageName = this.establishPageName(resource, cacheable);
        try {
            return this.createTemplate(resource, pageName, cacheable);
        }
        catch (IOException e) {
            throw new GroovyPagesException("Error loading template", e);
        }
    }

    protected Template createTemplate(Resource resource, String pageName, boolean cacheable) throws IOException {
        GroovyPageMetaInfo meta = cacheable ? (GroovyPageMetaInfo)CacheEntry.getValue(this.pageCache, (Object)pageName, (long)-1L, null, (Callable)new GroovyPagesTemplateEngineCallable(new GroovyPagesTemplateEngineCacheEntry(pageName)), (boolean)true, (Object)resource) : this.buildPageMetaInfo(resource, pageName);
        return new GroovyPageTemplate(meta);
    }

    protected String establishPageName(Resource resource, boolean cacheable) {
        String name = cacheable ? this.establishPageName(resource, this.getPathForResource(resource)) : this.establishPageName(resource, null);
        return name;
    }

    @Override
    public Template createTemplate(String uri) {
        return this.createTemplateForUri(uri);
    }

    private Template createTemplateFromPrecompiled(GroovyPageCompiledScriptSource compiledScriptSource) {
        GroovyPageResourceScriptSource changedResourceScriptSource;
        GroovyPageMetaInfo meta = this.initializeCompiledMetaInfo(compiledScriptSource.getGroovyPageMetaInfo());
        if (this.isReloadEnabled() && (changedResourceScriptSource = compiledScriptSource.getReloadableScriptSource()) != null) {
            this.groovyPageLocator.removePrecompiledPage(compiledScriptSource);
            return this.createTemplate(changedResourceScriptSource);
        }
        return new GroovyPageTemplate(meta);
    }

    private GroovyPageMetaInfo initializeCompiledMetaInfo(GroovyPageMetaInfo meta) {
        meta.initializeOnDemand(new GroovyPageMetaInfo.GroovyPageMetaInfoInitializer(){

            @Override
            public void initialize(GroovyPageMetaInfo metaInfo) {
                metaInfo.setGrailsApplication(GroovyPagesTemplateEngine.this.grailsApplication);
                metaInfo.setJspTagLibraryResolver(GroovyPagesTemplateEngine.this.jspTagLibraryResolver);
                metaInfo.setTagLibraryLookup(GroovyPagesTemplateEngine.this.tagLibraryLookup);
                metaInfo.initialize();
                GroovyPagesMetaUtils.registerMethodMissingForGSP(metaInfo.getPageClass(), GroovyPagesTemplateEngine.this.tagLibraryLookup);
            }
        });
        return meta;
    }

    public Template createTemplateForUri(String uri) {
        return this.createTemplateForUri(new String[]{uri});
    }

    @Override
    public Template createTemplateForUri(String[] uris) {
        GroovyPageScriptSource scriptSource = this.findScriptSource(uris);
        if (scriptSource != null) {
            return this.createTemplate(scriptSource);
        }
        return null;
    }

    public GroovyPageScriptSource findScriptSource(String uri) {
        return this.findScriptSource(new String[]{uri});
    }

    public GroovyPageScriptSource findScriptSource(String[] uris) {
        String uri;
        GroovyPageScriptSource scriptSource = null;
        String[] arr$ = uris;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (scriptSource = this.groovyPageLocator.findPage(uri = arr$[i$])) == null; ++i$) {
        }
        return scriptSource;
    }

    public Template createTemplate(ScriptSource scriptSource) {
        if (scriptSource instanceof GroovyPageCompiledScriptSource) {
            return this.createTemplateFromPrecompiled((GroovyPageCompiledScriptSource)scriptSource);
        }
        if (scriptSource instanceof ResourceScriptSource) {
            ResourceScriptSource resourceSource = (ResourceScriptSource)scriptSource;
            Resource resource = resourceSource.getResource();
            return this.createTemplate(resource, true);
        }
        try {
            return this.createTemplate(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
        }
        catch (IOException e) {
            throw new RuntimeException("IOException in createTemplate", e);
        }
    }

    public Template createTemplate(String txt, String pageName) throws IOException {
        Assert.hasLength((String)txt, (String)"Argument [txt] cannot be null or blank");
        Assert.hasLength((String)pageName, (String)"Argument [pageName] cannot be null or blank");
        return this.createTemplate((Resource)new ByteArrayResource(txt.getBytes("UTF-8"), pageName), pageName, pageName != null);
    }

    @Override
    public Template createTemplate(File file) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new FileSystemResource(file));
    }

    @Override
    public Template createTemplate(URL url) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate((Resource)new UrlResource(url));
    }

    @Override
    public Template createTemplate(InputStream inputStream) {
        GroovyPageMetaInfo metaInfo = this.buildPageMetaInfo(inputStream, null, null);
        return new GroovyPageTemplate(metaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroovyPageMetaInfo buildPageMetaInfo(Resource resource, String pageName) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            GroovyPageMetaInfo groovyPageMetaInfo = this.buildPageMetaInfo(inputStream, resource, pageName);
            return groovyPageMetaInfo;
        }
    }

    private StringBuilder decorateGroovyPageSource(StringBuilder source) throws IOException {
        for (GroovyPageSourceDecorator groovyPageSourceDecorator : this.groovyPageSourceDecorators) {
            source = groovyPageSourceDecorator.decorate(source);
        }
        return source;
    }

    private boolean isGroovyPageReloadable(final Resource resource, GroovyPageMetaInfo meta) {
        return this.isReloadEnabled() && meta.shouldReload(new PrivilegedAction<Resource>(){

            @Override
            public Resource run() {
                return resource;
            }
        });
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean b) {
        this.reloadEnabled = b;
    }

    public Resource getResourceForUri(String uri) {
        GroovyPageScriptSource scriptSource = this.getResourceWithinContext(uri);
        if (scriptSource != null && scriptSource instanceof GroovyPageResourceScriptSource) {
            return ((GroovyPageResourceScriptSource)scriptSource).getResource();
        }
        return null;
    }

    private GroovyPageScriptSource getResourceWithinContext(String uri) {
        Assert.state((this.groovyPageLocator != null ? 1 : 0) != 0, (String)"TemplateEngine not initialised correctly, no [groovyPageLocator] specified!");
        GroovyPageScriptSource scriptSource = this.groovyPageLocator.findPage(uri);
        if (scriptSource != null) {
            return scriptSource;
        }
        return null;
    }

    protected GroovyPageMetaInfo buildPageMetaInfo(InputStream inputStream, Resource res, String pageName) {
        GroovyPageParser parser;
        String name = this.establishPageName(res, pageName);
        String path = this.getPathForResource(res);
        try {
            String gspSource = IOUtils.toString((InputStream)inputStream, (String)GroovyPageParser.getGspEncoding());
            parser = new GroovyPageParser(name, path, path, this.decorateGroovyPageSource(new StringBuilder(gspSource)).toString());
            if (this.grailsApplication != null) {
                Config config = this.grailsApplication.getConfig();
                Object keepDirObj = config.getProperty("grails.views.gsp.keepgenerateddir", Object.class);
                if (keepDirObj instanceof File) {
                    parser.setKeepGeneratedDirectory((File)keepDirObj);
                } else if (keepDirObj != null) {
                    parser.setKeepGeneratedDirectory(new File(String.valueOf(keepDirObj)));
                }
            }
        }
        catch (IOException e) {
            throw new GroovyPagesException("I/O parsing Groovy page [" + (res != null ? res.getDescription() : name) + "]: " + e.getMessage(), e);
        }
        InputStream in = parser.parse();
        GroovyPageMetaInfo metaInfo = this.createPageMetaInfo(parser, in);
        metaInfo.applyLastModifiedFromResource(res);
        try {
            metaInfo.setPageClass(this.compileGroovyPage(in, name, path, metaInfo));
            metaInfo.setHtmlParts(parser.getHtmlPartsArray());
        }
        catch (GroovyPagesException e) {
            metaInfo.setCompilationException(e);
        }
        return metaInfo;
    }

    private String getPathForResource(Resource res) {
        if (res == null) {
            return "";
        }
        String path = null;
        try {
            File file = res.getFile();
            if (file != null) {
                path = file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path != null) {
            return path;
        }
        if (res.getDescription() != null) {
            return res.getDescription();
        }
        return "";
    }

    private Class<?> compileGroovyPage(InputStream in, String name, String pageName, GroovyPageMetaInfo metaInfo) {
        Class scriptClass;
        GroovyClassLoader groovyClassLoader = this.findOrInitGroovyClassLoader();
        try {
            String groovySource = IOGroovyMethods.getText((InputStream)in, (String)"UTF-8");
            scriptClass = groovyClassLoader.parseClass(groovySource, name);
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)("Compilation error compiling GSP [" + name + "]:" + e.getMessage()), (Throwable)e);
            int lineNumber = ExceptionUtils.extractLineNumber((CompilationFailedException)e);
            int[] lineMappings = metaInfo.getLineNumbers();
            if (lineNumber > 0 && lineNumber < lineMappings.length) {
                lineNumber = lineMappings[lineNumber - 1];
            }
            String relativePageName = DefaultErrorsPrinter.makeRelativeIfPossible((String)pageName);
            throw new GroovyPagesException("Could not parse script [" + relativePageName + "]: " + e.getMessage(), e, lineNumber, pageName);
        }
        catch (IOException e) {
            String relativePageName = DefaultErrorsPrinter.makeRelativeIfPossible((String)pageName);
            throw new GroovyPagesException("IO exception parsing script [" + relativePageName + "]: " + e.getMessage(), e);
        }
        GroovyPagesMetaUtils.registerMethodMissingForGSP(scriptClass, this.tagLibraryLookup);
        return scriptClass;
    }

    private synchronized GroovyClassLoader findOrInitGroovyClassLoader() {
        if (!(this.classLoader instanceof GroovyPageClassLoader)) {
            this.classLoader = this.initGroovyClassLoader(this.classLoader);
        }
        return (GroovyClassLoader)this.classLoader;
    }

    private GroovyPageMetaInfo createPageMetaInfo(GroovyPageParser parse, InputStream in) {
        GroovyPageMetaInfo pageMeta;
        block4: {
            pageMeta = new GroovyPageMetaInfo();
            pageMeta.setGrailsApplication(this.grailsApplication);
            pageMeta.setJspTagLibraryResolver(this.jspTagLibraryResolver);
            pageMeta.setTagLibraryLookup(this.tagLibraryLookup);
            pageMeta.setContentType(parse.getContentType());
            pageMeta.setLineNumbers(parse.getLineNumberMatrix());
            pageMeta.setJspTags(parse.getJspTags());
            pageMeta.setStaticCodecName(parse.getStaticCodecDirectiveValue());
            pageMeta.setExpressionCodecName(parse.getExpressionCodecDirectiveValue());
            pageMeta.setOutCodecName(parse.getOutCodecDirectiveValue());
            pageMeta.setTaglibCodecName(parse.getTaglibCodecDirectiveValue());
            pageMeta.initialize();
            if (GrailsUtil.isDevelopmentEnv()) {
                pageMeta.setGroovySource(in);
            }
            if (dumpLineNumbersTo != null) {
                String fileName = parse.getClassName() + "_linenumbers.data";
                File file = new File(dumpLineNumbersTo, fileName);
                try {
                    parse.writeLineNumbers(file);
                }
                catch (IOException ignored) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }
        return pageMeta;
    }

    protected String establishPageName(Resource res, String pageName) {
        if (res == null) {
            return this.generateTemplateName();
        }
        try {
            String name;
            String string = name = pageName != null ? pageName : res.getURL().getPath();
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            return name.replaceAll("[^\\w\\d]", "_");
        }
        catch (IllegalStateException e) {
            return this.generateTemplateName();
        }
        catch (IOException ioex) {
            return this.generateTemplateName();
        }
    }

    private String generateTemplateName() {
        return GENERATED_GSP_NAME_PREFIX + this.scriptNameCount.incrementAndGet();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext.containsBean("grailsApplication")) {
            this.grailsApplication = (GrailsApplication)applicationContext.getBean("grailsApplication", GrailsApplication.class);
        }
    }

    protected String getUriWithinGrailsViews(String relativeUri) {
        StringBuilder buf = new StringBuilder();
        if (relativeUri.startsWith("/")) {
            relativeUri = relativeUri.substring(1);
        }
        String[] tokens = relativeUri.indexOf(47) > -1 ? relativeUri.split("/") : new String[]{relativeUri};
        buf.append("/WEB-INF/grails-app/views");
        for (String token : tokens) {
            buf.append('/').append(token);
        }
        if (!relativeUri.endsWith(".gsp")) {
            buf.append(".gsp");
        }
        return buf.toString();
    }

    public void clearPageCache() {
        Iterator it = this.pageCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            GroovyPageMetaInfo metaInfo = (GroovyPageMetaInfo)((CacheEntry)entry.getValue()).getValue();
            if (metaInfo != null) {
                metaInfo.removePageMetaClass();
            }
            it.remove();
        }
    }

    public boolean isCacheResources() {
        return this.cacheResources;
    }

    public void setCacheResources(boolean cacheResources) {
        this.cacheResources = cacheResources;
    }

    public Map<String, Class<?>> getDomainClassMap() {
        if (this.cachedDomainsWithoutPackage != null) {
            return this.cachedDomainsWithoutPackage;
        }
        return this.createDomainClassMap();
    }

    private Map<String, Class<?>> createDomainClassMap() {
        HashMap domainsWithoutPackage = new HashMap();
        if (this.grailsApplication != null) {
            GrailsClass[] domainClasses;
            for (GrailsClass domainClass : domainClasses = this.grailsApplication.getArtefacts("Domain")) {
                Class theClass = domainClass.getClazz();
                domainsWithoutPackage.put(theClass.getName(), theClass);
            }
        }
        return domainsWithoutPackage;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        if (beanClassLoader != null && this.classLoader == null) {
            this.classLoader = beanClassLoader;
        }
    }

    public String getGspEncoding() {
        Object gspEnc;
        Map config = Holders.getFlatConfig();
        if (config != null && (gspEnc = config.get("grails.views.gsp.encoding")) != null && gspEnc.toString().trim().length() > 0) {
            return gspEnc.toString();
        }
        return System.getProperty("file.encoding", "us-ascii");
    }

    static {
        File dir;
        LOG = LogFactory.getLog(GroovyPagesTemplateEngine.class);
        String dirPath = System.getProperty("grails.dump.gsp.line.numbers.to.dir");
        if (dirPath != null && ((dir = new File(dirPath)).exists() || dir.mkdirs())) {
            dumpLineNumbersTo = dir;
        }
    }

    private static class GroovyPagesTemplateEngineCallable
    implements Callable<CacheEntry<GroovyPageMetaInfo>> {
        private final CacheEntry<GroovyPageMetaInfo> cacheEntry;

        public GroovyPagesTemplateEngineCallable(CacheEntry<GroovyPageMetaInfo> cacheEntry) {
            this.cacheEntry = cacheEntry;
        }

        @Override
        public CacheEntry<GroovyPageMetaInfo> call() throws Exception {
            return this.cacheEntry;
        }
    }

    private class GroovyPagesTemplateEngineCacheEntry
    extends CacheEntry<GroovyPageMetaInfo> {
        private final String pageName;

        public GroovyPagesTemplateEngineCacheEntry(String pageName) {
            this.pageName = pageName;
        }

        protected boolean hasExpired(long timeout, Object cacheRequestObject) {
            GroovyPageMetaInfo meta = (GroovyPageMetaInfo)this.getValue();
            Resource resource = (Resource)cacheRequestObject;
            return meta == null || GroovyPagesTemplateEngine.this.isGroovyPageReloadable(resource, meta);
        }

        protected GroovyPageMetaInfo updateValue(GroovyPageMetaInfo oldValue, Callable<GroovyPageMetaInfo> updater, Object cacheRequestObject) throws Exception {
            if (oldValue != null) {
                oldValue.removePageMetaClass();
            }
            Resource resource = (Resource)cacheRequestObject;
            return GroovyPagesTemplateEngine.this.buildPageMetaInfo(resource, this.pageName);
        }
    }
}

