/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.gorm;

import grails.persistence.Entity;
import grails.persistence.PersistenceMethod;
import groovy.transform.Canonical;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;

@AstTransformer
public class GormTransformer
extends AbstractGrailsArtefactTransformer {
    public static final String NEW_INSTANCE_METHOD = "newInstance";
    private static final Set<String> EXCLUDES = new HashSet<String>(Arrays.asList("create", "setTransactionManager"));
    private static final Set<String> INCLUDES = new HashSet<String>(Arrays.asList("getAll", "getCount", "getValidationSkipMap", "getValidationErrorsMap", "getAsync"));
    private static final Set<String> TRANSFORMED_CLASSES = new HashSet<String>();

    protected boolean isStaticMethodExcluded(ClassNode classNode, MethodNode declaredMethod) {
        return EXCLUDES.contains(declaredMethod.getName());
    }

    protected boolean isStaticMethodIncluded(ClassNode classNode, MethodNode declaredMethod) {
        return INCLUDES.contains(declaredMethod.getName());
    }

    public String getArtefactType() {
        return "Domain";
    }

    public Class<?> getInstanceImplementation() {
        return GormInstanceApi.class;
    }

    public Class<?> getStaticImplementation() {
        return GormStaticApi.class;
    }

    protected boolean requiresStaticLookupMethod() {
        return true;
    }

    protected AnnotationNode getMarkerAnnotation() {
        return new AnnotationNode(new ClassNode(PersistenceMethod.class).getPlainNodeReference());
    }

    protected void performInjectionInternal(String apiInstanceProperty, SourceUnit source, ClassNode classNode) {
        if (GrailsASTUtils.hasAnnotation((ClassNode)classNode, Canonical.class)) {
            GrailsASTUtils.error((SourceUnit)source, (ASTNode)classNode, (String)("Class [" + classNode.getName() + "] is marked with @groovy.transform.Canonical which is not supported for GORM entities."), (boolean)true);
        }
        classNode.setUsingGenerics(true);
        GrailsASTUtils.addAnnotationIfNecessary((ClassNode)classNode, Entity.class);
        TRANSFORMED_CLASSES.add(classNode.getName());
        BlockStatement methodBody = new BlockStatement();
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(classNode), NEW_INSTANCE_METHOD, (Expression)ZERO_ARGS)));
        MethodNode methodNode = classNode.getDeclaredMethod("create", ZERO_PARAMETERS);
        classNode = GrailsASTUtils.nonGeneric((ClassNode)classNode);
        if (methodNode == null) {
            classNode.addMethod(new MethodNode("create", 9, classNode, ZERO_PARAMETERS, null, (Statement)methodBody));
        }
    }

    public boolean shouldInject(URL url) {
        return GrailsResourceUtils.isDomainClass((URL)url);
    }

    public static Collection<String> getKnownEntityNames() {
        return Collections.unmodifiableCollection(TRANSFORMED_CLASSES);
    }
}

