/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import groovy.util.ConfigObject;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.CouldNotDetermineHibernateDialectException;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernateDialectDetectorFactoryBean
implements FactoryBean<String>,
InitializingBean,
GrailsApplicationAware {
    private DataSource dataSource;
    private Properties vendorNameDialectMappings;
    private String hibernateDialectClassName;
    private Dialect hibernateDialect;
    private GrailsApplication grailsApplication;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setVendorNameDialectMappings(Properties mappings) {
        this.vendorNameDialectMappings = mappings;
    }

    public String getObject() {
        return this.hibernateDialectClassName;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws MetaDataAccessException {
        Assert.notNull((Object)this.dataSource, (String)"Data source is not set!");
        Assert.notNull((Object)this.vendorNameDialectMappings, (String)"Vendor name/dialect mappings are not set!");
        Connection connection = null;
        String dbName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName");
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            try {
                ConfigObject config = this.grailsApplication != null ? this.grailsApplication.getConfig() : null;
                Properties properties = config != null ? config.toProperties() : new Properties();
                this.hibernateDialect = DialectFactory.buildDialect((Properties)properties, (Connection)connection);
                this.hibernateDialectClassName = this.hibernateDialect.getClass().getName();
            }
            catch (HibernateException e) {
                this.hibernateDialectClassName = this.vendorNameDialectMappings.getProperty(dbName);
            }
            if (!StringUtils.hasText((String)this.hibernateDialectClassName)) {
                throw new CouldNotDetermineHibernateDialectException("Could not determine Hibernate dialect for database name [" + dbName + "]!");
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

