/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import grails.util.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryProxy;
import org.codehaus.groovy.grails.orm.hibernate.events.SaveOrUpdateEventListener;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PostDeleteEvent;
import org.grails.datastore.mapping.engine.event.PostLoadEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.datastore.mapping.engine.event.PreDeleteEvent;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreLoadEvent;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.Executable;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ReflectionUtils;

public class ClosureEventTriggeringInterceptor
extends SaveOrUpdateEventListener
implements ApplicationContextAware,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener,
PreInsertEventListener {
    protected static final Log LOG = LogFactory.getLog(ClosureEventTriggeringInterceptor.class);
    private static final long serialVersionUID = 1L;
    public static final Collection<String> IGNORED = CollectionUtils.newSet((Object[])new String[]{"version", "id"});
    public static final String ONLOAD_EVENT = "onLoad";
    public static final String ONLOAD_SAVE = "onSave";
    public static final String BEFORE_LOAD_EVENT = "beforeLoad";
    public static final String BEFORE_INSERT_EVENT = "beforeInsert";
    public static final String AFTER_INSERT_EVENT = "afterInsert";
    public static final String BEFORE_UPDATE_EVENT = "beforeUpdate";
    public static final String AFTER_UPDATE_EVENT = "afterUpdate";
    public static final String BEFORE_DELETE_EVENT = "beforeDelete";
    public static final String AFTER_DELETE_EVENT = "afterDelete";
    public static final String AFTER_LOAD_EVENT = "afterLoad";
    private Method markInterceptorDirtyMethod;
    private ApplicationContext ctx;
    private Map<SessionFactory, HibernateDatastore> datastores;
    private static final ThreadLocal<Boolean> insertActiveThreadLocal = new ThreadLocal();
    private static final PreInsertEventListener NULLABILITY_CHECKER_INSTANCE = new NullabilityCheckerPreInsertEventListener();

    public ClosureEventTriggeringInterceptor() {
        try {
            this.markInterceptorDirtyMethod = ReflectionUtils.findMethod(AbstractSaveEventListener.class, (String)"markInterceptorDirty", (Class[])new Class[]{Object.class, EntityPersister.class, EventSource.class});
            ReflectionUtils.makeAccessible((Method)this.markInterceptorDirtyMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDatastores(Map<SessionFactory, HibernateDatastore> datastores) {
        this.datastores = datastores;
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent hibernateEvent) throws HibernateException {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new org.grails.datastore.mapping.engine.event.SaveOrUpdateEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
        super.onSaveOrUpdate(hibernateEvent);
    }

    public void onPreLoad(org.hibernate.event.PreLoadEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PreLoadEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public void onPostLoad(org.hibernate.event.PostLoadEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostLoadEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public boolean onPreInsert(org.hibernate.event.PreInsertEvent hibernateEvent) {
        PreInsertEvent event = new PreInsertEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostInsert(PostInsertEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new org.grails.datastore.mapping.engine.event.PostInsertEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public boolean onPreUpdate(PreUpdateEvent hibernateEvent) {
        org.grails.datastore.mapping.engine.event.PreUpdateEvent event = new org.grails.datastore.mapping.engine.event.PreUpdateEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostUpdate(org.hibernate.event.PostUpdateEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostUpdateEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public boolean onPreDelete(org.hibernate.event.PreDeleteEvent hibernateEvent) {
        PreDeleteEvent event = new PreDeleteEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostDelete(org.hibernate.event.PostDeleteEvent hibernateEvent) {
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostDeleteEvent(this.findDatastore((AbstractEvent)hibernateEvent), hibernateEvent.getEntity()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.ctx = applicationContext;
    }

    private void publishEvent(AbstractEvent hibernateEvent, AbstractPersistenceEvent mappingEvent) {
        mappingEvent.setNativeEvent((Serializable)hibernateEvent);
        this.ctx.publishEvent((ApplicationEvent)mappingEvent);
    }

    private Datastore findDatastore(AbstractEvent hibernateEvent) {
        Datastore datastore;
        SessionFactory sessionFactory = hibernateEvent.getSession().getSessionFactory();
        if (!(sessionFactory instanceof SessionFactoryProxy)) {
            for (Map.Entry<SessionFactory, HibernateDatastore> entry : this.datastores.entrySet()) {
                SessionFactory sf = entry.getKey();
                if (!(sf instanceof SessionFactoryProxy) || ((SessionFactoryProxy)sf).getCurrentSessionFactory() != sessionFactory) continue;
                return (Datastore)entry.getValue();
            }
        }
        if ((datastore = (Datastore)this.datastores.get(sessionFactory)) == null && this.datastores.size() == 1) {
            datastore = (Datastore)this.datastores.values().iterator().next();
        }
        return datastore;
    }

    protected Serializable performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        this.validate(entity, persister, source);
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTxn = source.getJDBCContext().isTransactionInProgress();
        boolean shouldDelayIdentityInserts = !inTxn && !requiresImmediateIdAccess;
        source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        if (useIdentityColumn && !shouldDelayIdentityInserts) {
            LOG.trace((Object)"executing insertions");
            source.getActionQueue().executeInserts();
        }
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(anything), (SessionImplementor)source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, (SessionImplementor)source);
        if (persister.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollectionsBeforeSave(entity, id, values, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values, source.getEntityMode());
        }
        TypeHelper.deepCopy((Object[])values, (Type[])types, (boolean[])persister.getPropertyUpdateability(), (Object[])values, (SessionImplementor)source);
        new ForeignKeys.Nullifier(entity, false, useIdentityColumn, (SessionImplementor)source).nullifyTransientReferences(values, types);
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, (SessionImplementor)source, shouldDelayIdentityInserts);
            if (!shouldDelayIdentityInserts) {
                LOG.debug((Object)"executing identity-insert immediately");
                source.getActionQueue().execute((Executable)insert);
                id = insert.getGeneratedId();
                if (id != null) {
                    key = new EntityKey(id, persister, source.getEntityMode());
                    source.getPersistenceContext().checkUniqueness(key, entity);
                }
            } else {
                LOG.debug((Object)"delaying identity-insert due to no transaction in progress");
                source.getActionQueue().addAction(insert);
                key = insert.getDelayedEntityKey();
            }
        }
        if (key != null) {
            Object version = Versioning.getVersion((Object[])values, (EntityPersister)persister);
            source.getPersistenceContext().addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, values, key, version, LockMode.WRITE, useIdentityColumn, persister, this.isVersionIncrementDisabled(), false);
            if (!useIdentityColumn) {
                source.getActionQueue().addAction(new EntityInsertAction(id, values, entity, version, persister, (SessionImplementor)source));
            }
            this.cascadeAfterSave(source, persister, entity, anything);
            if (this.markInterceptorDirtyMethod != null) {
                ReflectionUtils.invokeMethod((Method)this.markInterceptorDirtyMethod, (Object)((Object)this), (Object[])new Object[]{entity, persister, source});
            }
        }
        return id;
    }

    public static final void addNullabilityCheckerPreInsertEventListener(EventListeners listenerRegistry) {
        PreInsertEventListener[] preListeners = listenerRegistry.getPreInsertEventListeners();
        if (preListeners == null) {
            preListeners = new PreInsertEventListener[1];
        } else {
            PreInsertEventListener[] newPreListeners = new PreInsertEventListener[preListeners.length + 1];
            System.arraycopy(preListeners, 0, newPreListeners, 0, preListeners.length);
            preListeners = newPreListeners;
        }
        preListeners[preListeners.length - 1] = NULLABILITY_CHECKER_INSTANCE;
        listenerRegistry.setPreInsertEventListeners(preListeners);
    }

    protected Boolean getAssumedUnsaved() {
        return insertActiveThreadLocal.get();
    }

    public static void markInsertActive() {
        insertActiveThreadLocal.set(Boolean.TRUE);
    }

    public static void resetInsertActive() {
        insertActiveThreadLocal.remove();
    }

    private static class NullabilityCheckerPreInsertEventListener
    implements PreInsertEventListener {
        private NullabilityCheckerPreInsertEventListener() {
        }

        public boolean onPreInsert(org.hibernate.event.PreInsertEvent event) {
            new Nullability((SessionImplementor)event.getSession()).checkNullability(event.getState(), event.getPersister(), false);
            return false;
        }
    }
}

