/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import grails.validation.ValidationException;
import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.gorm.support.BeforeValidateHelper;
import org.grails.datastore.gorm.support.EventTriggerCaller;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.engine.ActionQueue;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.AbstractPreDatabaseOperationEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Errors;

public class ClosureEventListener
implements SaveOrUpdateEventListener,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog(ClosureEventListener.class);
    EventTriggerCaller saveOrUpdateCaller;
    EventTriggerCaller beforeInsertCaller;
    EventTriggerCaller preLoadEventCaller;
    EventTriggerCaller postLoadEventListener;
    EventTriggerCaller postInsertEventListener;
    EventTriggerCaller postUpdateEventListener;
    EventTriggerCaller postDeleteEventListener;
    EventTriggerCaller preDeleteEventListener;
    EventTriggerCaller preUpdateEventListener;
    BeforeValidateHelper.BeforeValidateEventTriggerCaller beforeValidateEventListener;
    boolean shouldTimestamp = false;
    MetaProperty dateCreatedProperty;
    MetaProperty lastUpdatedProperty;
    MetaClass domainMetaClass;
    boolean failOnErrorEnabled = false;
    MetaProperty errorsProperty;
    Map validateParams;
    MetaMethod validateMethod;
    private Field actionQueueUpdatesField;
    private Field entityUpdateActionStateField;

    public ClosureEventListener(Class<?> domainClazz, boolean failOnError, List failOnErrorPackages) {
        this.domainMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(domainClazz);
        this.dateCreatedProperty = this.domainMetaClass.getMetaProperty("dateCreated");
        this.lastUpdatedProperty = this.domainMetaClass.getMetaProperty("lastUpdated");
        if (this.dateCreatedProperty != null || this.lastUpdatedProperty != null) {
            Mapping m = new GrailsDomainBinder().getMapping(domainClazz);
            this.shouldTimestamp = m == null || m.isAutoTimestamp();
        }
        this.saveOrUpdateCaller = this.buildCaller("onSave", domainClazz);
        this.beforeInsertCaller = this.buildCaller("beforeInsert", domainClazz);
        this.preLoadEventCaller = this.buildCaller("onLoad", domainClazz);
        if (this.preLoadEventCaller == null) {
            this.preLoadEventCaller = this.buildCaller("beforeLoad", domainClazz);
        }
        this.postLoadEventListener = this.buildCaller("afterLoad", domainClazz);
        this.postInsertEventListener = this.buildCaller("afterInsert", domainClazz);
        this.postUpdateEventListener = this.buildCaller("afterUpdate", domainClazz);
        this.postDeleteEventListener = this.buildCaller("afterDelete", domainClazz);
        this.preDeleteEventListener = this.buildCaller("beforeDelete", domainClazz);
        this.preUpdateEventListener = this.buildCaller("beforeUpdate", domainClazz);
        this.beforeValidateEventListener = new BeforeValidateHelper.BeforeValidateEventTriggerCaller(domainClazz, this.domainMetaClass);
        this.failOnErrorEnabled = failOnErrorPackages.size() > 0 ? GrailsClassUtils.isClassBelowPackage(domainClazz, (List)failOnErrorPackages) : failOnError;
        this.validateParams = new HashMap();
        this.validateParams.put("deepValidate", Boolean.FALSE);
        this.errorsProperty = this.domainMetaClass.getMetaProperty("errors");
        this.validateMethod = this.domainMetaClass.getMetaMethod("validate", new Object[]{Map.class});
        try {
            this.actionQueueUpdatesField = ReflectionUtils.findField(ActionQueue.class, (String)"updates");
            this.actionQueueUpdatesField.setAccessible(true);
            this.entityUpdateActionStateField = ReflectionUtils.findField(EntityUpdateAction.class, (String)"state");
            this.entityUpdateActionStateField.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private EventTriggerCaller buildCaller(String eventName, Class<?> domainClazz) {
        return EventTriggerCaller.buildCaller((String)eventName, domainClazz, (MetaClass)this.domainMetaClass, null);
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
    }

    private void synchronizePersisterState(AbstractPreDatabaseOperationEvent event, Object[] state) {
        Object entity = event.getEntity();
        EntityPersister persister = event.getPersister();
        String[] propertyNames = persister.getPropertyNames();
        HashMap<Integer, Object> changedState = new HashMap<Integer, Object>();
        for (int i = 0; i < propertyNames.length; ++i) {
            String p = propertyNames[i];
            MetaProperty metaProperty = this.domainMetaClass.getMetaProperty(p);
            if (ClosureEventTriggeringInterceptor.IGNORED.contains(p) || metaProperty == null) continue;
            Object value = metaProperty.getProperty(entity);
            if (state[i] != value) {
                changedState.put(i, value);
            }
            state[i] = value;
            persister.setPropertyValue(entity, i, value, EntityMode.POJO);
        }
        this.synchronizeEntityUpdateActionState(event, entity, changedState);
    }

    protected void synchronizeEntityUpdateActionState(AbstractPreDatabaseOperationEvent event, Object entity, HashMap<Integer, Object> changedState) {
        if (this.actionQueueUpdatesField != null && event instanceof PreInsertEvent && changedState.size() > 0) {
            try {
                List updates = (List)this.actionQueueUpdatesField.get(event.getSource().getActionQueue());
                if (updates != null) {
                    for (EntityUpdateAction updateAction : updates) {
                        Object[] updateState;
                        if (updateAction.getInstance() != entity || (updateState = (Object[])this.entityUpdateActionStateField.get(updateAction)) == null) continue;
                        for (Map.Entry<Integer, Object> entry : changedState.entrySet()) {
                            updateState[entry.getKey().intValue()] = entry.getValue();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception in synchronizeEntityUpdateActionState", (Throwable)e);
            }
        }
    }

    public void onPreLoad(final PreLoadEvent event) {
        if (this.preLoadEventCaller == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.preLoadEventCaller.call(event.getEntity());
                return null;
            }
        });
    }

    public void onPostLoad(final PostLoadEvent event) {
        if (this.postLoadEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postLoadEventListener.call(event.getEntity());
                return null;
            }
        });
    }

    public void onPostInsert(PostInsertEvent event) {
        final Object entity = event.getEntity();
        AbstractSavePersistentMethod.clearDisabledValidations(entity);
        if (this.postInsertEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postInsertEventListener.call(entity);
                return null;
            }
        });
    }

    public void onPostUpdate(PostUpdateEvent event) {
        final Object entity = event.getEntity();
        AbstractSavePersistentMethod.clearDisabledValidations(entity);
        if (this.postUpdateEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postUpdateEventListener.call(entity);
                return null;
            }
        });
    }

    public void onPostDelete(PostDeleteEvent event) {
        final Object entity = event.getEntity();
        AbstractSavePersistentMethod.clearDisabledValidations(entity);
        if (this.postDeleteEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postDeleteEventListener.call(entity);
                return null;
            }
        });
    }

    public boolean onPreDelete(final PreDeleteEvent event) {
        if (this.preDeleteEventListener == null) {
            return false;
        }
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                return ClosureEventListener.this.preDeleteEventListener.call(event.getEntity());
            }
        });
    }

    public boolean onPreUpdate(final PreUpdateEvent event) {
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                Object entity = event.getEntity();
                boolean evict = false;
                if (ClosureEventListener.this.preUpdateEventListener != null) {
                    evict = ClosureEventListener.this.preUpdateEventListener.call(entity);
                    ClosureEventListener.this.synchronizePersisterState((AbstractPreDatabaseOperationEvent)event, event.getState());
                }
                if (ClosureEventListener.this.shouldTimestamp) {
                    String[] propertyNames;
                    Object now;
                    long time = System.currentTimeMillis();
                    if (ClosureEventListener.this.dateCreatedProperty != null && ClosureEventListener.this.dateCreatedProperty.getProperty(entity) == null) {
                        now = ClosureEventListener.this.applyTimestamp(entity, ClosureEventListener.this.dateCreatedProperty, time);
                        propertyNames = event.getPersister().getPropertyNames();
                        event.getState()[Arrays.asList(propertyNames).indexOf((Object)"dateCreated")] = now;
                    }
                    if (ClosureEventListener.this.lastUpdatedProperty != null) {
                        now = ClosureEventListener.this.applyTimestamp(entity, ClosureEventListener.this.lastUpdatedProperty, time);
                        propertyNames = event.getPersister().getPropertyNames();
                        event.getState()[Arrays.asList(propertyNames).indexOf((Object)"lastUpdated")] = now;
                    }
                }
                if (!AbstractSavePersistentMethod.isAutoValidationDisabled(entity) && !DefaultTypeTransformation.castToBoolean((Object)ClosureEventListener.this.validateMethod.invoke(entity, new Object[]{ClosureEventListener.this.validateParams}))) {
                    evict = true;
                    if (ClosureEventListener.this.failOnErrorEnabled) {
                        Errors errors = (Errors)ClosureEventListener.this.errorsProperty.getProperty(entity);
                        throw new ValidationException("Validation error whilst flushing entity [" + entity.getClass().getName() + "]", errors);
                    }
                }
                return evict;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithManualSession(AbstractEvent event, Closure<T> callable) {
        EventSource session = event.getSession();
        FlushMode current = session.getFlushMode();
        try {
            session.setFlushMode(FlushMode.MANUAL);
            Object object = callable.call();
            return (T)object;
        }
        finally {
            session.setFlushMode(current);
        }
    }

    public boolean onPreInsert(final PreInsertEvent event) {
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                Object entity = event.getEntity();
                boolean synchronizeState = false;
                if (ClosureEventListener.this.beforeInsertCaller != null) {
                    if (ClosureEventListener.this.beforeInsertCaller.call(entity)) {
                        return true;
                    }
                    synchronizeState = true;
                }
                if (ClosureEventListener.this.shouldTimestamp) {
                    long time = System.currentTimeMillis();
                    if (ClosureEventListener.this.dateCreatedProperty != null) {
                        ClosureEventListener.this.applyTimestamp(entity, ClosureEventListener.this.dateCreatedProperty, time);
                        synchronizeState = true;
                    }
                    if (ClosureEventListener.this.lastUpdatedProperty != null) {
                        ClosureEventListener.this.applyTimestamp(entity, ClosureEventListener.this.lastUpdatedProperty, time);
                        synchronizeState = true;
                    }
                }
                if (synchronizeState) {
                    ClosureEventListener.this.synchronizePersisterState((AbstractPreDatabaseOperationEvent)event, event.getState());
                }
                boolean evict = false;
                if (!AbstractSavePersistentMethod.isAutoValidationDisabled(entity) && !DefaultTypeTransformation.castToBoolean((Object)ClosureEventListener.this.validateMethod.invoke(entity, new Object[]{ClosureEventListener.this.validateParams}))) {
                    evict = true;
                    if (ClosureEventListener.this.failOnErrorEnabled) {
                        Errors errors = (Errors)ClosureEventListener.this.errorsProperty.getProperty(entity);
                        throw new ValidationException("Validation error whilst flushing entity [" + entity.getClass().getName() + "]", errors);
                    }
                }
                return evict;
            }
        });
    }

    protected Object applyTimestamp(Object entity, MetaProperty property, long time) {
        Object now = DefaultGroovyMethods.newInstance((Class)property.getType(), (Object[])new Object[]{time});
        property.setProperty(entity, now);
        return now;
    }

    public void onValidate(ValidationEvent event) {
        this.beforeValidateEventListener.call(event.getEntityObject(), event.getValidatedFields());
    }
}

