/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.proxy;

import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.support.proxy.EntityProxyHandler;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.hibernate.Hibernate;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.proxy.LazyInitializer;

public class HibernateProxyHandler
implements EntityProxyHandler {
    public boolean isInitialized(Object o) {
        if (o instanceof HibernateProxy) {
            return !((HibernateProxy)o).getHibernateLazyInitializer().isUninitialized();
        }
        if (o instanceof PersistentCollection) {
            return ((PersistentCollection)o).wasInitialized();
        }
        return true;
    }

    public boolean isInitialized(Object obj, String associationName) {
        try {
            Object proxy = ClassPropertyFetcher.forClass(obj.getClass()).getPropertyValue(obj, associationName);
            return Hibernate.isInitialized((Object)proxy);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public Object unwrapIfProxy(Object instance) {
        if (instance instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)instance;
            return this.unwrapProxy(proxy);
        }
        if (instance instanceof AbstractPersistentCollection) {
            this.initialize(instance);
            return instance;
        }
        return instance;
    }

    public Object unwrapProxy(HibernateProxy proxy) {
        Object obj;
        LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
        if (lazyInitializer.isUninitialized()) {
            lazyInitializer.initialize();
        }
        if ((obj = lazyInitializer.getImplementation()) != null) {
            GrailsHibernateUtil.ensureCorrectGroovyMetaClass(obj, obj.getClass());
        }
        return obj;
    }

    public HibernateProxy getAssociationProxy(Object obj, String associationName) {
        try {
            Object proxy = ClassPropertyFetcher.forClass(obj.getClass()).getPropertyValue(obj, associationName);
            if (proxy instanceof HibernateProxy) {
                return (HibernateProxy)proxy;
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean isProxy(Object o) {
        return o instanceof HibernateProxy || o instanceof AbstractPersistentCollection;
    }

    public void initialize(Object o) {
        AbstractPersistentCollection col;
        if (o instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)o).getHibernateLazyInitializer();
            if (hibernateLazyInitializer.isUninitialized()) {
                hibernateLazyInitializer.initialize();
            }
        } else if (o instanceof AbstractPersistentCollection && !(col = (AbstractPersistentCollection)o).wasInitialized()) {
            col.forceInitialization();
        }
    }

    public Object getProxyIdentifier(Object o) {
        if (o instanceof HibernateProxy) {
            return ((HibernateProxy)o).getHibernateLazyInitializer().getIdentifier();
        }
        return null;
    }

    public Class<?> getProxiedClass(Object o) {
        return HibernateProxyHelper.getClassWithoutInitializingProxy((Object)o);
    }
}

