/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.validation.ValidationErrors;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public abstract class AbstractDynamicPersistentMethod
extends AbstractDynamicMethodInvocation {
    public static final String ERRORS_PROPERTY = "errors";
    private ClassLoader classLoader;
    private HibernateTemplate hibernateTemplate;
    GrailsApplication application;

    public AbstractDynamicPersistentMethod(Pattern pattern, SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        super(pattern);
        Assert.notNull((Object)sessionFactory, (String)"Session factory is required!");
        this.classLoader = classLoader;
        Assert.notNull((Object)application, (String)"Constructor argument 'application' cannot be null");
        this.application = application;
        this.hibernateTemplate = new GrailsHibernateTemplate(sessionFactory, application);
    }

    protected HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object target, String methodName, Object[] arguments) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = this.doInvokeInternal(target, arguments);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    protected abstract Object doInvokeInternal(Object var1, Object[] var2);

    protected void setObjectToReadOnly(Object target) {
        GrailsHibernateUtil.setObjectToReadyOnly(target, this.getHibernateTemplate().getSessionFactory());
    }

    protected void setObjectToReadWrite(Object target) {
        GrailsHibernateUtil.setObjectToReadWrite(target, this.getHibernateTemplate().getSessionFactory());
    }

    protected Errors setupErrorsProperty(Object target) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        ValidationErrors errors = new ValidationErrors(target);
        Errors originalErrors = (Errors)mc.getProperty(target, ERRORS_PROPERTY);
        for (Object o : originalErrors.getFieldErrors()) {
            FieldError fe = (FieldError)o;
            if (!fe.isBindingFailure()) continue;
            errors.addError((ObjectError)new FieldError(fe.getObjectName(), fe.getField(), fe.getRejectedValue(), fe.isBindingFailure(), fe.getCodes(), fe.getArguments(), fe.getDefaultMessage()));
        }
        mc.setProperty(target, ERRORS_PROPERTY, (Object)errors);
        return errors;
    }
}

