/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import grails.util.Environment;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.HibernateEventListeners;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryHolder;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryProxy;
import org.codehaus.groovy.grails.orm.hibernate.cfg.DefaultGrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.codehaus.groovy.grails.orm.hibernate.transaction.HibernateJtaTransactionManagerAdapter;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.orm.hibernate3.LocalTransactionManagerLookup;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ReflectionUtils;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean
implements ApplicationContextAware {
    protected static final Log LOG = LogFactory.getLog(ConfigurableLocalSessionFactoryBean.class);
    protected ClassLoader classLoader;
    protected GrailsApplication grailsApplication;
    protected Class<?> configClass;
    protected Class<?> currentSessionContextClass;
    protected HibernateEventListeners hibernateEventListeners;
    protected ApplicationContext applicationContext;
    protected boolean proxyIfReloadEnabled = true;
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = "DEFAULT";
    protected PlatformTransactionManager transactionManager;

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setProxyIfReloadEnabled(boolean proxyIfReloadEnabled) {
        this.proxyIfReloadEnabled = proxyIfReloadEnabled;
    }

    public void setCurrentSessionContextClass(Class<?> currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public void setConfigClass(Class<?> configClass) {
        this.configClass = configClass;
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    protected Configuration newConfiguration() {
        Object config;
        ClassLoader cl;
        ClassLoader classLoader = cl = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        if (this.configClass == null) {
            try {
                this.configClass = cl.loadClass("org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsAnnotationConfiguration");
            }
            catch (Throwable e) {
                this.configClass = DefaultGrailsDomainConfiguration.class;
            }
        }
        if ((config = BeanUtils.instantiateClass(this.configClass)) instanceof GrailsDomainConfiguration) {
            GrailsDomainConfiguration grailsConfig = (GrailsDomainConfiguration)config;
            grailsConfig.setGrailsApplication(this.grailsApplication);
            grailsConfig.setSessionFactoryBeanName(this.sessionFactoryBeanName);
            grailsConfig.setDataSourceName(this.dataSourceName);
        }
        if (this.currentSessionContextClass != null) {
            ((Configuration)config).setProperty("hibernate.current_session_context_class", this.currentSessionContextClass.getName());
            this.setExposeTransactionAwareSessionFactory(false);
        }
        return (Configuration)config;
    }

    protected void postProcessMappings(Configuration config) throws HibernateException {
        super.postProcessMappings(config);
        if (this.requiresJtaTransactionManagerAdapter()) {
            this.configureJtaTransactionManagerAdapter(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionFactory buildSessionFactory() throws Exception {
        try {
            SessionFactory sessionFactory = super.buildSessionFactory();
            return sessionFactory;
        }
        finally {
            this.getConfigTimeTransactionManagerHolder().remove();
        }
    }

    protected boolean requiresJtaTransactionManagerAdapter() {
        return ConfigurableLocalSessionFactoryBean.getConfigTimeTransactionManager() == null && this.getTransactionManager() != null;
    }

    protected void configureJtaTransactionManagerAdapter(Configuration config) {
        this.getConfigTimeTransactionManagerHolder().set((TransactionManager)new HibernateJtaTransactionManagerAdapter(this.getTransactionManager()));
        config.setProperty("hibernate.transaction.manager_lookup_class", LocalTransactionManagerLookup.class.getName());
    }

    protected ThreadLocal<TransactionManager> getConfigTimeTransactionManagerHolder() {
        Field configTimeTransactionManagerHolderField = ReflectionUtils.findField(LocalSessionFactoryBean.class, (String)"configTimeTransactionManagerHolder");
        ReflectionUtils.makeAccessible((Field)configTimeTransactionManagerHolderField);
        ThreadLocal configTimeTransactionManagerHolder = (ThreadLocal)ReflectionUtils.getField((Field)configTimeTransactionManagerHolderField, null);
        return configTimeTransactionManagerHolder;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.classLoader = beanClassLoader;
        super.setBeanClassLoader(beanClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.classLoader);
            super.afterPropertiesSet();
        }
        finally {
            thread.setContextClassLoader(cl);
        }
    }

    protected SessionFactory newSessionFactory(Configuration configuration) throws HibernateException {
        try {
            SessionFactory sf = super.newSessionFactory(configuration);
            if (!Environment.getCurrent().isReloadEnabled() || !this.proxyIfReloadEnabled) {
                return sf;
            }
            SessionFactoryProxy sfp = new SessionFactoryProxy();
            String suffix = this.dataSourceName.equals("DEFAULT") ? "" : '_' + this.dataSourceName;
            SessionFactoryHolder sessionFactoryHolder = (SessionFactoryHolder)this.applicationContext.getBean("org.grails.internal.SESSION_FACTORY_HOLDER" + suffix, SessionFactoryHolder.class);
            sessionFactoryHolder.setSessionFactory(sf);
            sfp.setApplicationContext(this.applicationContext);
            sfp.setCurrentSessionContextClass(this.currentSessionContextClass);
            sfp.setTargetBean("org.grails.internal.SESSION_FACTORY_HOLDER" + suffix);
            sfp.afterPropertiesSet();
            return sfp;
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            if (this.isCacheConfigurationError(cause)) {
                LOG.error((Object)("There was an error configuring the Hibernate second level cache: " + this.getCauseMessage(e)));
                LOG.error((Object)"This is normally due to one of two reasons. Either you have incorrectly specified the cache provider class name in [DataSource.groovy] or you do not have the cache provider on your classpath (eg. runtime (\"net.sf.ehcache:ehcache:1.6.1\"))");
                if (Environment.isDevelopmentMode()) {
                    System.exit(1);
                }
            }
            throw e;
        }
    }

    protected String getCauseMessage(HibernateException e) {
        Throwable cause = e.getCause();
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause.getMessage();
    }

    protected boolean isCacheConfigurationError(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause != null && cause instanceof CacheException;
    }

    public void destroy() throws HibernateException {
        if (this.grailsApplication.isWarDeployed()) {
            MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
            Map classMetaData = this.getSessionFactory().getAllClassMetadata();
            for (Object o : classMetaData.values()) {
                ClassMetadata classMetadata = (ClassMetadata)o;
                Class mappedClass = classMetadata.getMappedClass(EntityMode.POJO);
                registry.removeMetaClass(mappedClass);
            }
        }
        try {
            super.destroy();
        }
        catch (HibernateException e) {
            if (e.getCause() instanceof NameNotFoundException) {
                LOG.debug((Object)e.getCause().getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
        EventListeners listeners = config.getEventListeners();
        if (this.hibernateEventListeners != null && this.hibernateEventListeners.getListenerMap() != null) {
            Map listenerMap = this.hibernateEventListeners.getListenerMap();
            this.addNewListenerToConfiguration(config, "auto-flush", AutoFlushEventListener.class, listeners.getAutoFlushEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "merge", MergeEventListener.class, listeners.getMergeEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "create", PersistEventListener.class, listeners.getPersistEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "create-onflush", PersistEventListener.class, listeners.getPersistOnFlushEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "delete", DeleteEventListener.class, listeners.getDeleteEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "dirty-check", DirtyCheckEventListener.class, listeners.getDirtyCheckEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "evict", EvictEventListener.class, listeners.getEvictEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "flush", FlushEventListener.class, listeners.getFlushEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "flush-entity", FlushEntityEventListener.class, listeners.getFlushEntityEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "load", LoadEventListener.class, listeners.getLoadEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "load-collection", InitializeCollectionEventListener.class, listeners.getInitializeCollectionEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "lock", LockEventListener.class, listeners.getLockEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "refresh", RefreshEventListener.class, listeners.getRefreshEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "replicate", ReplicateEventListener.class, listeners.getReplicateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "save-update", SaveOrUpdateEventListener.class, listeners.getSaveOrUpdateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "save", SaveOrUpdateEventListener.class, listeners.getSaveEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "update", SaveOrUpdateEventListener.class, listeners.getUpdateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-load", PreLoadEventListener.class, listeners.getPreLoadEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-update", PreUpdateEventListener.class, listeners.getPreUpdateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-delete", PreDeleteEventListener.class, listeners.getPreDeleteEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-insert", PreInsertEventListener.class, listeners.getPreInsertEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-collection-recreate", PreCollectionRecreateEventListener.class, listeners.getPreCollectionRecreateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-collection-remove", PreCollectionRemoveEventListener.class, listeners.getPreCollectionRemoveEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "pre-collection-update", PreCollectionUpdateEventListener.class, listeners.getPreCollectionUpdateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-load", PostLoadEventListener.class, listeners.getPostLoadEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-update", PostUpdateEventListener.class, listeners.getPostUpdateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-delete", PostDeleteEventListener.class, listeners.getPostDeleteEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-insert", PostInsertEventListener.class, listeners.getPostInsertEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-commit-update", PostUpdateEventListener.class, listeners.getPostCommitUpdateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-commit-delete", PostDeleteEventListener.class, listeners.getPostCommitDeleteEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-commit-insert", PostInsertEventListener.class, listeners.getPostCommitInsertEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-collection-recreate", PostCollectionRecreateEventListener.class, listeners.getPostCollectionRecreateEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-collection-remove", PostCollectionRemoveEventListener.class, listeners.getPostCollectionRemoveEventListeners(), listenerMap);
            this.addNewListenerToConfiguration(config, "post-collection-update", PostCollectionUpdateEventListener.class, listeners.getPostCollectionUpdateEventListeners(), listenerMap);
        }
        ClosureEventTriggeringInterceptor.addNullabilityCheckerPreInsertEventListener(listeners);
    }

    protected <T> void addNewListenerToConfiguration(Configuration config, String listenerType, Class<? extends T> klass, T[] currentListeners, Map<String, Object> newlistenerMap) {
        Object newListener = newlistenerMap.get(listenerType);
        if (newListener == null) {
            return;
        }
        if (currentListeners != null && currentListeners.length > 0) {
            Object[] newListeners = (Object[])Array.newInstance(klass, currentListeners.length + 1);
            System.arraycopy(currentListeners, 0, newListeners, 0, currentListeners.length);
            newListeners[currentListeners.length] = newListener;
            config.setListeners(listenerType, newListeners);
        } else {
            config.setListener(listenerType, newListener);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }
}

