/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import grails.core.GrailsApplication;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Properties;
import org.grails.web.sitemesh.GrailsNoDecorator;
import org.grails.web.sitemesh.GroovyPageLayoutFinder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsLayoutDecoratorMapper
extends AbstractDecoratorMapper {
    private GroovyPageLayoutFinder groovyPageLayoutFinder;
    public static final String LAYOUT_ATTRIBUTE = "org.grails.layout.name";
    public static final String NONE_LAYOUT = "_none_";
    public static final String RENDERING_VIEW = "org.grails.rendering.view";

    public void init(Config c, Properties properties, DecoratorMapper parentMapper) throws InstantiationException {
        super.init(c, properties, parentMapper);
        ServletContext servletContext = c.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (applicationContext != null) {
            GrailsApplication grailsApplication = (GrailsApplication)applicationContext.getBean("grailsApplication", GrailsApplication.class);
            this.groovyPageLayoutFinder = (GroovyPageLayoutFinder)grailsApplication.getMainContext().getBean("groovyPageLayoutFinder", GroovyPageLayoutFinder.class);
        }
    }

    public Decorator getDecorator(HttpServletRequest request, Page page) {
        if (this.groovyPageLayoutFinder == null) {
            return super.getDecorator(request, page);
        }
        Decorator layout = this.groovyPageLayoutFinder.findLayout(request, page);
        if (layout != null) {
            return layout;
        }
        Decorator decorator = layout = this.parent != null ? super.getDecorator(request, page) : null;
        if (layout == null || layout.getPage() == null) {
            layout = new GrailsNoDecorator();
        }
        return layout;
    }

    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        if (this.groovyPageLayoutFinder == null) {
            return super.getNamedDecorator(request, name);
        }
        Decorator layout = this.groovyPageLayoutFinder.getNamedDecorator(request, name);
        if (layout != null) {
            return layout;
        }
        Decorator decorator = layout = this.parent != null ? super.getNamedDecorator(request, name) : null;
        if (layout == null || layout.getPage() == null) {
            layout = new GrailsNoDecorator();
        }
        return layout;
    }
}

