/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.sitemesh;

import com.opensymphony.sitemesh.Content;
import groovy.text.Template;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.grails.web.servlet.WrappedResponseHolder;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.mvc.OutputAwareHttpServletResponse;
import org.grails.web.servlet.view.AbstractGrailsView;
import org.grails.web.sitemesh.GSPSitemeshPage;
import org.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.grails.web.sitemesh.GrailsViewBufferingResponse;
import org.grails.web.sitemesh.GroovyPageLayoutFinder;
import org.grails.web.sitemesh.SpringMVCViewDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class GrailsLayoutView
extends AbstractGrailsView {
    private static final Logger LOG = LoggerFactory.getLogger(GrailsLayoutView.class);
    GroovyPageLayoutFinder groovyPageLayoutFinder;
    protected View innerView;
    public static final String GSP_SITEMESH_PAGE = GrailsLayoutView.class.getName() + ".GSP_SITEMESH_PAGE";

    public GrailsLayoutView(GroovyPageLayoutFinder groovyPageLayoutFinder, View innerView) {
        this.groovyPageLayoutFinder = groovyPageLayoutFinder;
        this.innerView = innerView;
    }

    public String getContentType() {
        return "*/*";
    }

    protected void renderTemplate(Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Content content;
        boolean isCommitted;
        boolean bl = isCommitted = response.isCommitted() && response instanceof OutputAwareHttpServletResponse && !((OutputAwareHttpServletResponse)response).isWriterAvailable();
        if (!isCommitted && (content = this.obtainContent(model, webRequest, request, response)) != null) {
            this.beforeDecorating(content, model, webRequest, request, response);
            switch (request.getDispatcherType()) {
                case INCLUDE: {
                    break;
                }
                case ASYNC: 
                case ERROR: 
                case FORWARD: 
                case REQUEST: {
                    SpringMVCViewDecorator decorator;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding layout for request and content");
                    }
                    if ((decorator = (SpringMVCViewDecorator)this.groovyPageLayoutFinder.findLayout(request, content)) == null) break;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Found layout [%s], rendering content for model [%s]", decorator.getPage(), model));
                    }
                    decorator.render(content, model, request, response, webRequest.getServletContext());
                    return;
                }
            }
            PrintWriter writer = response.getWriter();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Layout not applicable to response, writing original content");
            }
            content.writeOriginal((Writer)writer);
            if (!response.isCommitted()) {
                writer.flush();
            }
        }
    }

    protected void beforeDecorating(Content content, Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        this.applyMetaHttpEquivContentType(content, response);
    }

    protected void applyMetaHttpEquivContentType(Content content, HttpServletResponse response) {
        String contentType = content.getProperty("meta.http-equiv.Content-Type");
        if (contentType != null && "text/html".equals(response.getContentType())) {
            response.setContentType(contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Content obtainContent(Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object oldPage = request.getAttribute("__sitemesh__page");
        request.removeAttribute("__sitemesh__page");
        Object oldGspSiteMeshPage = request.getAttribute(GSP_SITEMESH_PAGE);
        HttpServletResponse previousResponse = webRequest.getWrappedResponse();
        HttpServletResponse previousWrappedResponse = WrappedResponseHolder.getWrappedResponse();
        try {
            request.setAttribute(GSP_SITEMESH_PAGE, (Object)new GSPSitemeshPage());
            GrailsContentBufferingResponse contentBufferingResponse = this.createContentBufferingResponse(model, webRequest, request, response);
            webRequest.setWrappedResponse((HttpServletResponse)contentBufferingResponse);
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)contentBufferingResponse);
            this.renderInnerView(model, webRequest, request, response, contentBufferingResponse);
            Content content = contentBufferingResponse.getContent();
            return content;
        }
        finally {
            if (oldGspSiteMeshPage != null) {
                request.setAttribute(GSP_SITEMESH_PAGE, oldGspSiteMeshPage);
            }
            if (oldPage != null) {
                request.setAttribute("__sitemesh__page", oldPage);
            }
            webRequest.setWrappedResponse(previousResponse);
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)previousWrappedResponse);
        }
    }

    protected void renderInnerView(Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response, GrailsContentBufferingResponse contentBufferingResponse) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rendering inner view for layout and model [{}]", model);
        }
        this.innerView.render(model, request, (HttpServletResponse)contentBufferingResponse);
    }

    protected GrailsContentBufferingResponse createContentBufferingResponse(Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        return new GrailsViewBufferingResponse(request, response);
    }

    public Template getTemplate() {
        if (this.innerView instanceof AbstractGrailsView) {
            return ((AbstractGrailsView)this.innerView).getTemplate();
        }
        return null;
    }

    public View getInnerView() {
        return this.innerView;
    }
}

