/*
 * Decompiled with CFR 0.152.
 */
package org.grails.scaffolding.registry;

import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.grails.scaffolding.model.property.DomainProperty;
import org.grails.scaffolding.registry.DomainRenderer;

public abstract class DomainRendererRegistry<T extends DomainRenderer> {
    protected SortedSet<Entry> domainRegistryEntries = new TreeSet<Entry>();
    protected final AtomicInteger RENDERER_SEQUENCE = new AtomicInteger(0);

    void registerDomainRenderer(T domainRenderer, Integer priority) {
        this.domainRegistryEntries.add(new Entry(this, domainRenderer, priority.intValue()));
    }

    public SortedSet<Entry> getDomainRegistryEntries() {
        return this.domainRegistryEntries;
    }

    public T get(DomainProperty domainProperty) {
        for (Entry entry : this.domainRegistryEntries) {
            if (!entry.renderer.supports(domainProperty)) continue;
            return entry.renderer;
        }
        return null;
    }

    private class Entry
    implements Comparable<Entry> {
        protected final T renderer;
        private final int priority;
        private final int seq;
        final /* synthetic */ DomainRendererRegistry this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        Entry(T renderer, int priority) {
            this.this$0 = (DomainRendererRegistry)n;
            this.renderer = renderer;
            this.priority = priority;
            this.seq = n.RENDERER_SEQUENCE.incrementAndGet();
        }

        @Override
        public int compareTo(Entry entry) {
            return this.priority == entry.priority ? entry.seq - this.seq : entry.priority - this.priority;
        }
    }
}

