/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.EventContextObject;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightPerContext;
import com.oracle.truffle.tools.agentscript.impl.InsightSourceFilter;
import com.oracle.truffle.tools.agentscript.impl.NullObject;
import com.oracle.truffle.tools.agentscript.impl.RootNameFilter;
import com.oracle.truffle.tools.agentscript.impl.VariablesObject;

final class InsightHookNode
extends ExecutionEventNode {
    @Node.Child
    private InteropLibrary checkApplicable;
    @Node.Child
    private InteropLibrary enterDispatch;
    @Node.Child
    private InteropLibrary exitDispatch;
    @Node.Child
    private NodeLibrary nodeDispatch;
    @Node.Child
    private InteropLibrary exceptionDispatch;
    private final InsightInstrument.Key key;
    private final EventContext ctx;
    private final Node instrumentedNode;
    private final InsightInstrument insight;
    private final String rootName;
    private final Source src;

    private InsightHookNode(InsightInstrument.Key key, InsightInstrument insight, EventContext ctx) {
        this.key = key;
        this.insight = insight;
        this.checkApplicable = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        this.enterDispatch = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        this.exitDispatch = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        this.exceptionDispatch = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        Node node = ctx.getInstrumentedNode();
        this.nodeDispatch = (NodeLibrary)NodeLibrary.getFactory().create((Object)node);
        this.ctx = ctx;
        this.instrumentedNode = node;
        this.rootName = node.getRootNode().getName();
        this.src = ctx.getInstrumentedSourceSection().getSource();
    }

    protected void onEnter(VirtualFrame frame) {
        this.loopHooks(frame, AgentType.ENTER, null);
    }

    protected void onReturnValue(VirtualFrame frame, Object returnValue) {
        this.loopHooks(frame, AgentType.RETURN, returnValue);
    }

    protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
        this.loopHooks(frame, AgentType.RETURN, null);
    }

    protected Object onUnwind(VirtualFrame frame, Object info) {
        return info;
    }

    private void loopHooks(VirtualFrame frame, AgentType type, Object returnValue) throws RuntimeException, ThreadDeath {
        int len = this.key.functionsMaxCount();
        CompilerAsserts.partialEvaluationConstant((int)len);
        InsightPerContext ipc = this.insight.findCtx();
        ReturnNow returnNow = null;
        for (int i = 0; i < len; ++i) {
            InsightFilter.Data data = (InsightFilter.Data)ipc.functionFor(this.key, i);
            if (!this.isApplicable(data, type)) continue;
            EventContextObject eco = this.eventCtxObj();
            try {
                this.exitDispatch.execute(data.fn, new Object[]{eco, this.getVariables(frame, type == AgentType.ENTER, returnValue)});
                continue;
            }
            catch (ReturnNow ex) {
                if (returnNow != null) continue;
                returnNow = ex;
                continue;
            }
            catch (InteropException ex) {
                throw EventContextObject.wrap(data.fn, 2, ex);
            }
            catch (RuntimeException ex) {
                throw EventContextObject.rethrow(ex, this.exceptionDispatch);
            }
        }
        if (returnNow != null) {
            throw this.ctx.createUnwind(NullObject.nullCheck(returnNow.returnValue));
        }
    }

    static ControlFlowException returnNow(Object[] args) throws ArityException {
        return new ReturnNow(switch (args.length) {
            case 0 -> null;
            case 1 -> args[0];
            default -> throw ArityException.create((int)1, (int)1, (int)args.length);
        });
    }

    private Object getVariables(VirtualFrame frame, boolean nodeEnter, Object returnValue) {
        if (this.nodeDispatch.hasScope((Object)this.instrumentedNode, (Frame)frame)) {
            try {
                Object scope = this.nodeDispatch.getScope((Object)this.instrumentedNode, (Frame)frame, nodeEnter);
                if (returnValue != null) {
                    return new VariablesObject(scope, returnValue);
                }
                return scope;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return ArrayObject.array(new String[0]);
    }

    private boolean isApplicable(InsightFilter.Data data, AgentType agentType) {
        if (data == null) {
            return false;
        }
        if (data.type != agentType) {
            return false;
        }
        if (data.rootNameFn != null && !RootNameFilter.rootNameCheck(this.checkApplicable, data, this.rootName)) {
            return false;
        }
        return data.sourceFilterFn == null || InsightSourceFilter.checkSource(this.checkApplicable, data, this.src);
    }

    private EventContextObject eventCtxObj() {
        return new EventContextObject(this.ctx);
    }

    public String toString() {
        return super.toString() + " at " + this.ctx.getInstrumentedNode().getSourceSection();
    }

    static ExecutionEventNodeFactory factory(final InsightInstrument insight, final InsightInstrument.Key key) {
        return new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext context) {
                return new InsightHookNode(key, insight, context);
            }
        };
    }

    private static final class ReturnNow
    extends ControlFlowException {
        static final long serialVersionUID = 49092343L;
        final Object returnValue;

        ReturnNow(Object returnValue) {
            this.returnValue = returnValue;
        }
    }
}

