/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class InsightPerContext {
    final InsightInstrument insight;
    final TruffleContext context;
    private final Map<InsightInstrument.Key, List<Object>> functionsForBinding = new HashMap<InsightInstrument.Key, List<Object>>();
    @CompilerDirectives.CompilationFinal
    private int functionsLen;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private Object[][] functionsArray;
    @CompilerDirectives.CompilationFinal
    private Assumption functionsArrayValid;

    InsightPerContext(InsightInstrument insight, TruffleContext context) {
        this.insight = insight;
        this.context = context;
    }

    synchronized void register(InsightInstrument.Key key, Object function) {
        this.invalidateFunctionsArray();
        List<Object> arr = this.functionsForBinding.get(key);
        if (arr == null) {
            arr = new ArrayList<Object>();
            this.functionsForBinding.put(key, arr);
        }
        arr.add(function);
        key.adjustSize(arr.size());
    }

    synchronized boolean unregister(InsightInstrument.Key key, Object function) {
        this.invalidateFunctionsArray();
        if (key == null) {
            boolean r = false;
            for (List<Object> arr : this.functionsForBinding.values()) {
                Iterator<Object> it = arr.iterator();
                while (it.hasNext()) {
                    InsightFilter.Data data = (InsightFilter.Data)it.next();
                    if (!function.equals(data.fn)) continue;
                    it.remove();
                    r = true;
                }
            }
            return r;
        }
        List<Object> arr = this.functionsForBinding.get(key);
        if (arr != null) {
            return arr.remove(function);
        }
        return false;
    }

    Object functionFor(InsightInstrument.Key key, int at) {
        Object[] functions;
        int index = key.index();
        if (index >= 0) {
            if (this.functionsArray == null || !this.functionsArrayValid.isValid()) {
                this.updateFunctionsArraySlow();
            }
            functions = this.functionsArray[index];
        } else {
            functions = null;
        }
        return functions == null || at >= functions.length ? null : functions[at];
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void updateFunctionsArraySlow() {
        Object[][] fn = new Object[this.insight.keysLength()][];
        for (Map.Entry<InsightInstrument.Key, List<Object>> entry : this.functionsForBinding.entrySet()) {
            int index = entry.getKey().index();
            if (index == -1) continue;
            fn[index] = entry.getValue().toArray();
        }
        this.functionsArrayValid = this.insight.keysUnchangedAssumption();
        this.functionsArray = fn;
    }

    @CompilerDirectives.TruffleBoundary
    private void invalidateFunctionsArray() {
        assert (Thread.holdsLock(this));
        this.functionsArray = null;
        if (this.functionsArrayValid != null) {
            this.functionsArrayValid.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    void onClosed(InsightInstrument.Key closedKey) {
        InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        int len = closedKey.functionsMaxCount();
        for (int i = 0; i < len; ++i) {
            Object closeFn = this.functionFor(closedKey, i);
            if (closeFn == null) continue;
            try {
                iop.execute(closeFn, new Object[0]);
                continue;
            }
            catch (InteropException ex) {
                throw InsightException.raise((Exception)((Object)ex));
            }
        }
        InsightPerContext insightPerContext = this;
        synchronized (insightPerContext) {
            this.functionsForBinding.clear();
            this.invalidateFunctionsArray();
        }
    }
}

