/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class, delegateTo="scope")
final class CurrentScopeView
implements TruffleObject {
    final Object scope;

    CurrentScopeView(Object scope) {
        this.scope = scope;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this.scope") InteropLibrary scopeLib, @CachedLibrary(limit="5") InteropLibrary parentScopeLib) throws UnsupportedMessageException {
        Object allKeys = scopeLib.getMembers(this.scope);
        if (scopeLib.hasScopeParent(this.scope)) {
            Object parentScope = scopeLib.getScopeParent(this.scope);
            Object parentKeys = parentScopeLib.getMembers(parentScope);
            return new SubtractedKeys(allKeys, parentKeys);
        }
        return allKeys;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class SubtractedKeys
    implements TruffleObject {
        final Object allKeys;
        private final long allSize;
        private final long removedSize;

        SubtractedKeys(Object allKeys, Object removedKeys) throws UnsupportedMessageException {
            this.allKeys = allKeys;
            this.allSize = InteropLibrary.getUncached().getArraySize(allKeys);
            this.removedSize = InteropLibrary.getUncached().getArraySize(removedKeys);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.allSize - this.removedSize;
        }

        @ExportMessage
        Object readArrayElement(long index, @CachedLibrary(value="this.allKeys") InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
            if (0L <= index && index < this.getArraySize()) {
                return interop.readArrayElement(this.allKeys, index);
            }
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        boolean isArrayElementReadable(long index, @CachedLibrary(value="this.allKeys") InteropLibrary interop) {
            if (0L <= index && index < this.getArraySize()) {
                return interop.isArrayElementReadable(this.allKeys, index);
            }
            return false;
        }
    }
}

