/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class RegexNameFilter
implements Predicate<String> {
    private final Pattern regex;

    RegexNameFilter(String fn) {
        try {
            this.regex = Pattern.compile(fn);
        }
        catch (PatternSyntaxException ex) {
            throw InsightException.raise(ex);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean test(String rootName) {
        if (rootName == null) {
            return false;
        }
        return this.regex.matcher(rootName).matches();
    }
}

