/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightHookNode;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightPerContext;
import com.oracle.truffle.tools.agentscript.impl.InsightPerSource;
import java.io.IOException;

@ExportLibrary(value=InteropLibrary.class)
final class AgentObject
implements TruffleObject {
    private final InsightInstrument insight;
    private final InsightPerSource source;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] msg;

    AgentObject(String msg, InsightInstrument insight, InsightPerSource source) {
        this.msg = msg == null ? null : msg.getBytes();
        this.insight = insight;
        this.source = source;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        return true;
    }

    @ExportMessage
    static boolean hasMembers(AgentObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(AgentObject obj, boolean includeInternal) {
        return ArrayObject.array("id", "version");
    }

    @ExportMessage
    Object readMember(String name) throws UnknownIdentifierException {
        this.warnMsg();
        switch (name) {
            case "id": {
                return "insight";
            }
            case "version": {
                return "1.2";
            }
        }
        throw UnknownIdentifierException.create((String)name);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Object invokeMember(AgentObject obj, String member, Object[] args, @CachedLibrary(limit="0") InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException {
        obj.warnMsg();
        InsightPerContext perContext = obj.insight.findCtx();
        block4 : switch (member) {
            case "on": {
                AgentType type = AgentType.find(AgentObject.convertToString(interop, args[0]));
                switch (type) {
                    case SOURCE: {
                        InsightInstrument.Key b = obj.source.sourceBinding();
                        perContext.register(b, args[1]);
                        break block4;
                    }
                    case ENTER: 
                    case RETURN: {
                        InsightFilter.Data data = InsightFilter.create(type, args);
                        obj.source.binding(data, key -> {
                            perContext.register((InsightInstrument.Key)key, data);
                            return InsightHookNode.factory(obj.insight, key);
                        }, key -> perContext.register((InsightInstrument.Key)key, data));
                        break block4;
                    }
                    case CLOSE: {
                        InsightInstrument.Key b = obj.source.closeBinding();
                        perContext.register(b, args[1]);
                        break block4;
                    }
                }
                throw new IllegalStateException();
            }
            case "off": {
                AgentType type = AgentType.find(AgentObject.convertToString(interop, args[0]));
                switch (type) {
                    case SOURCE: {
                        InsightInstrument.Key b = obj.source.sourceBinding();
                        perContext.unregister(b, args[1]);
                        break block4;
                    }
                    case CLOSE: {
                        InsightInstrument.Key b = obj.source.closeBinding();
                        perContext.unregister(b, args[1]);
                        break block4;
                    }
                }
                perContext.unregister(null, args[1]);
                break;
            }
            default: {
                throw UnknownIdentifierException.create((String)member);
            }
        }
        return obj;
    }

    private void warnMsg() {
        byte[] arr = this.msg;
        if (arr != null) {
            try {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.insight.env().err().write(arr);
                this.msg = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String convertToString(InteropLibrary interop, Object obj) throws UnsupportedMessageException {
        return interop.asString(obj);
    }

    @ExportMessage
    static boolean isMemberInvocable(AgentObject obj, String member) {
        return false;
    }
}

