/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graalvm.collections.EconomicMap;

final class InsightFilter {
    private static final String CONFIG_EXPRESSIONS = "expressions";
    private static final String CONFIG_STATEMENTS = "statements";
    private static final String CONFIG_ROOTS = "roots";
    private static final String CONFIG_ROOT_FILTER = "rootNameFilter";
    private static final String CONFIG_SOURCE_FILTER = "sourceFilter";
    private static final String CONFIG_AT = "at";
    private static final Set<String> CONFIG_PROPS = new HashSet<String>(Arrays.asList("expressions", "statements", "roots", "rootNameFilter", "sourceFilter", "at"));
    private static final String AT_SOURCE_PATH = "sourcePath";
    private static final String AT_SOURCE_URI = "sourceURI";
    private static final String AT_LINE = "line";
    private static final String AT_COLUMN = "column";
    private static final Set<String> AT_PROPS = new HashSet<String>(Arrays.asList("sourcePath", "sourceURI", "line", "column"));
    private static final InteropLibrary IOP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private final Set<Class<? extends Tag>> allTags;
    private final String rootNameRegExp;
    private final String sourcePathRegExp;
    private final URI sourceURI;
    private final int line;
    private final int column;
    private final Reference<Object> rootNameFn;
    private final int rootNameFnHash;
    private final Reference<Object> sourceFilterFn;
    private final int sourceFilterFnHash;

    private InsightFilter(Set<Class<? extends Tag>> allTags, String rootNameRegExp, URI sourceURI, String sourcePathRegExp, int line, int column, Object rootNameFn, Object sourceFilterFn) {
        this.allTags = allTags;
        this.rootNameRegExp = rootNameRegExp;
        this.sourceURI = sourceURI;
        this.sourcePathRegExp = sourcePathRegExp;
        this.line = line;
        this.column = column;
        this.rootNameFn = new WeakReference<Object>(rootNameFn);
        this.rootNameFnHash = rootNameFn != null ? rootNameFn.hashCode() : 0;
        this.sourceFilterFn = new WeakReference<Object>(sourceFilterFn);
        this.sourceFilterFnHash = sourceFilterFn != null ? sourceFilterFn.hashCode() : 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.allTags);
        hash = 79 * hash + Objects.hashCode(this.rootNameRegExp);
        hash = 79 * hash + Objects.hashCode(this.sourcePathRegExp);
        hash = 79 * hash + Objects.hashCode(this.sourceURI);
        hash = 79 * hash + this.line;
        hash = 79 * hash + this.column;
        hash = 79 * hash + this.rootNameFnHash;
        hash = 79 * hash + this.sourceFilterFnHash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InsightFilter other = (InsightFilter)obj;
        if (this.rootNameFn.get() != other.rootNameFn.get()) {
            return false;
        }
        if (this.sourceFilterFn.get() != other.sourceFilterFn.get()) {
            return false;
        }
        if (!Objects.equals(this.rootNameRegExp, other.rootNameRegExp)) {
            return false;
        }
        if (!Objects.equals(this.allTags, other.allTags)) {
            return false;
        }
        if (!Objects.equals(this.sourcePathRegExp, other.sourcePathRegExp)) {
            return false;
        }
        if (!Objects.equals(this.sourceURI, other.sourceURI)) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return this.column == other.column;
    }

    Class<?>[] getTags() {
        return this.allTags.toArray(new Class[0]);
    }

    Set<Class<? extends Tag>> getTagsSet() {
        return this.allTags;
    }

    String getRootNameRegExp() {
        return this.rootNameRegExp;
    }

    String getSourcePathRegExp() {
        return this.sourcePathRegExp;
    }

    URI getSourceURI() {
        return this.sourceURI;
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }

    static Data create(AgentType aType, Object[] arr) throws IllegalArgumentException, UnsupportedMessageException {
        HashSet<Class<? extends Tag>> allTags = new HashSet<Class<? extends Tag>>();
        String rootNameRegExp = null;
        Object rootNameFn = null;
        Object sourceFilterFn = null;
        String sourcePathRegExp = null;
        URI sourceURI = null;
        int lineIs = 0;
        int columnIs = 0;
        if (arr != null && arr.length > 2) {
            Object at;
            Object sourceFilter;
            Object rootNameFilter;
            Object config = arr[2];
            ObjectReader configReader = ObjectReader.get(config, CONFIG_PROPS);
            if (configReader.is(CONFIG_EXPRESSIONS)) {
                allTags.add(StandardTags.ExpressionTag.class);
            }
            if (configReader.is(CONFIG_STATEMENTS)) {
                allTags.add(StandardTags.StatementTag.class);
            }
            if (configReader.is(CONFIG_ROOTS)) {
                allTags.add(StandardTags.RootBodyTag.class);
            }
            if ((rootNameFilter = configReader.get(CONFIG_ROOT_FILTER)) != null) {
                if (IOP.isString(rootNameFilter)) {
                    rootNameRegExp = IOP.asString(rootNameFilter);
                } else {
                    if (!IOP.isExecutable(rootNameFilter)) {
                        throw new IllegalArgumentException("rootNameFilter should be a string, a regular expression!");
                    }
                    rootNameFn = rootNameFilter;
                }
            }
            if ((sourceFilter = configReader.get(CONFIG_SOURCE_FILTER)) != null) {
                if (!IOP.isExecutable(sourceFilter)) {
                    throw new IllegalArgumentException("sourceFilter has to be a function!");
                }
                sourceFilterFn = sourceFilter;
            }
            if ((at = configReader.get(CONFIG_AT)) != null) {
                Object columnValue;
                Object lineValue;
                ObjectReader atReader = ObjectReader.get(at, AT_PROPS);
                Object sourcePath = atReader.get(AT_SOURCE_PATH);
                Object sourceURIValue = atReader.get(AT_SOURCE_URI);
                if (sourcePath != null && sourceURIValue != null) {
                    throw new IllegalArgumentException("Both sourceURI and sourcePath is defined. Only one source specification is expected.");
                }
                if (sourcePath == null && sourceURIValue == null) {
                    throw new IllegalArgumentException("Neither sourceURI nor sourcePath is defined. A source specification is expected.");
                }
                if (sourceURIValue != null) {
                    if (!IOP.isString(sourceURIValue)) {
                        throw new IllegalArgumentException("sourceURI is not a string.");
                    }
                    try {
                        sourceURI = new URI(IOP.asString(sourceURIValue));
                    }
                    catch (URISyntaxException uex) {
                        throw new IllegalArgumentException("sourceURI is not a valid URI: " + uex.getLocalizedMessage());
                    }
                }
                if (sourcePath != null) {
                    if (!IOP.isString(sourcePath)) {
                        throw new IllegalArgumentException("sourcePath is not a string!");
                    }
                    sourcePathRegExp = IOP.asString(sourcePath);
                }
                if ((lineValue = atReader.get(AT_LINE)) != null) {
                    lineIs = InsightFilter.getPositiveNumber(lineValue, "Source line");
                }
                if ((columnValue = atReader.get(AT_COLUMN)) != null) {
                    columnIs = InsightFilter.getPositiveNumber(columnValue, "Source column");
                }
            }
        }
        if (allTags.isEmpty()) {
            throw new IllegalArgumentException("No elements specified to listen to for execution listener. Need to specify at least one element kind: expressions, statements or roots.");
        }
        InsightFilter filter = new InsightFilter(allTags, rootNameRegExp, sourceURI, sourcePathRegExp, lineIs, columnIs, rootNameFn, sourceFilterFn);
        return new Data(aType, filter, arr[1], rootNameFn, sourceFilterFn);
    }

    private static int getPositiveNumber(Object value, String errMsg) throws UnsupportedMessageException {
        int num;
        if (value == null) {
            return 0;
        }
        if (IOP.fitsInInt(value) && (num = IOP.asInt(value)) > 0) {
            return num;
        }
        throw new IllegalArgumentException(errMsg + " is not a positive number or does not fit in integer type: " + IOP.asString(IOP.toDisplayString(value)));
    }

    public static final class Data {
        final AgentType type;
        final InsightFilter filter;
        final Object fn;
        final Object rootNameFn;
        final Object sourceFilterFn;

        private Data(AgentType type, InsightFilter filter, Object fn, Object rootNameFn, Object sourceFilterFn) {
            this.type = type;
            this.filter = filter;
            this.fn = fn;
            this.rootNameFn = rootNameFn;
            this.sourceFilterFn = sourceFilterFn;
        }
    }

    private static class MembersObjectReader
    extends ObjectReader {
        private final Object object;

        MembersObjectReader(Object object) {
            if (!IOP.hasMembers(object)) {
                try {
                    throw new IllegalArgumentException("Config object " + IOP.asString(IOP.toDisplayString(object)) + " does not have members.");
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            this.object = object;
        }

        @Override
        Object get(String propertyName) {
            Object value;
            try {
                value = IOP.readMember(this.object, propertyName);
                if (value != null && IOP.isNull(value)) {
                    value = null;
                }
            }
            catch (UnknownIdentifierException ex) {
                value = null;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return value;
        }
    }

    private static class HashObjectReader
    extends ObjectReader {
        private final EconomicMap<String, Object> map = EconomicMap.create();

        HashObjectReader(Object object, Set<String> properties) {
            try {
                Object it = IOP.getHashEntriesIterator(object);
                while (IOP.hasIteratorNextElement(it)) {
                    try {
                        Object value;
                        String name;
                        Object keyAndValue = IOP.getIteratorNextElement(it);
                        try {
                            Object key = IOP.readArrayElement(keyAndValue, 0L);
                            name = IOP.asString(key);
                            if (!properties.contains(name)) {
                                throw InsightException.unknownAttribute(name);
                            }
                            value = IOP.readArrayElement(keyAndValue, 1L);
                        }
                        catch (InvalidArrayIndexException ex) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                        }
                        if (IOP.isNull(value)) continue;
                        this.map.put((Object)name, value);
                    }
                    catch (StopIterationException ex) {
                        break;
                    }
                }
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Override
        Object get(String propertyName) {
            return this.map.get((Object)propertyName);
        }
    }

    private static abstract class ObjectReader {
        private ObjectReader() {
        }

        static ObjectReader get(Object object, Set<String> properties) {
            if (IOP.hasHashEntries(object)) {
                return new HashObjectReader(object, properties);
            }
            return new MembersObjectReader(object);
        }

        boolean is(String propertyName) {
            Object value = this.get(propertyName);
            try {
                return value != null && IOP.isBoolean(value) && IOP.asBoolean(value);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        abstract Object get(String var1);
    }
}

