/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.util.Collection;

@ExportLibrary(value=InteropLibrary.class)
final class ArrayObject
implements TruffleObject {
    private final Object[] arr;
    private final boolean convertToString;

    private ArrayObject(Object[] arr, boolean convertToString) {
        this.arr = arr;
        this.convertToString = convertToString;
    }

    @ExportMessage
    Object readArrayElement(long index) {
        Object value = this.arr[(int)index];
        if (this.convertToString) {
            return ArrayObject.toString(value);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    private static String toString(Object value) {
        return value.toString();
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.arr.length;
    }

    @ExplodeLoop
    boolean contains(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.arr.length; ++i) {
            if (!name.equals(this.readArrayElement(i))) continue;
            return true;
        }
        return false;
    }

    static ArrayObject array(String ... arr) {
        return new ArrayObject(arr, false);
    }

    static ArrayObject wrap(Collection<?> arr) {
        return new ArrayObject(arr.toArray(), false);
    }

    static ArrayObject wrap(Enum<?>[] arr) {
        return new ArrayObject(arr, true);
    }
}

