/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class RegexSourceFilter
implements SourceSectionFilter.SourcePredicate {
    private final Pattern regex;

    RegexSourceFilter(String sourcePath) {
        try {
            this.regex = Pattern.compile(sourcePath);
        }
        catch (PatternSyntaxException ex) {
            throw InsightException.raise(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean test(Source source) {
        String sourcePath = source.getPath();
        if (sourcePath == null) {
            sourcePath = source.getName();
        }
        return sourcePath != null && this.regex.matcher(sourcePath).matches();
    }
}

