/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightPerContext;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;
import java.util.Map;
import java.util.function.Predicate;

final class InsightSourceFilter
implements Predicate<Source> {
    private final InsightInstrument insight;
    private final ThreadLocal<Boolean> querying;
    private final InsightInstrument.Key key;

    InsightSourceFilter(InsightInstrument insight, InsightInstrument.Key key) {
        this.insight = insight;
        this.key = key;
        this.querying = new ThreadLocal();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean test(Source src) {
        if (src == null) {
            return false;
        }
        if (this.key.isClosed()) {
            return false;
        }
        InsightPerContext ctx = this.insight.findCtx();
        Map<Source, Boolean> cache = ctx.getSourceCache(this);
        Boolean previous = cache.get(src);
        if (previous != null) {
            return previous;
        }
        boolean now = this.realCheck(src);
        cache.put(src, now);
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean realCheck(Source src) {
        Boolean prev = this.querying.get();
        try {
            if (Boolean.TRUE.equals(prev)) {
                boolean bl = false;
                return bl;
            }
            if (this.key.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.querying.set(true);
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            int len = this.key.functionsMaxCount();
            InsightPerContext ctx = this.insight.findCtx();
            for (int i = 0; i < len; ++i) {
                InsightFilter.Data data = (InsightFilter.Data)ctx.functionFor(this.key, i);
                if (data == null || data.sourceFilterFn == null || !InsightSourceFilter.checkSource(iop, data, src)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.querying.set(prev);
        }
    }

    static boolean checkSource(InteropLibrary iop, InsightFilter.Data data, Source src) {
        Object res;
        SourceEventObject srcObj = new SourceEventObject(src);
        try {
            res = iop.execute(data.sourceFilterFn, new Object[]{srcObj});
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException ex) {
            return false;
        }
        boolean is = Boolean.TRUE.equals(res);
        return is;
    }
}

