/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentObject;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.IgnoreSources;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightSourceFilter;
import com.oracle.truffle.tools.agentscript.impl.RegexNameFilter;
import com.oracle.truffle.tools.agentscript.impl.RootNameFilter;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class InsightPerSource
implements ContextsListener,
AutoCloseable,
LoadSourceListener {
    private final InsightInstrument instrument;
    private final Supplier<Source> src;
    private final AgentObject insight;
    private final IgnoreSources ignoredSources;
    private volatile EventBinding<?> agentBinding;
    private InsightInstrument.Key sourceBinding;
    private InsightInstrument.Key closeBinding;
    private Map<Object, InsightInstrument.Key> bindings = new HashMap<Object, InsightInstrument.Key>();
    private Map<TruffleContext, Source> registeredSource = new WeakHashMap<TruffleContext, Source>();
    private final EventBinding<InsightPerSource> onInit;

    InsightPerSource(Instrumenter instrumenter, InsightInstrument instrument, Supplier<Source> src, IgnoreSources ignoredSources) {
        this.instrument = instrument;
        this.ignoredSources = ignoredSources;
        this.src = src;
        this.insight = instrument.createInsightObject(this);
        this.onInit = instrumenter.attachContextsListener((ContextsListener)this, true);
    }

    void collectSymbols(List<String> argNames, List<Object> args) {
        argNames.add("insight");
        args.add(this.insight);
        this.instrument.collectGlobalSymbolsImpl(this, argNames, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    void initializeAgent(TruffleContext ctx) {
        CallTarget target;
        Source script;
        InsightPerSource insightPerSource = this;
        synchronized (insightPerSource) {
            if (this.registeredSource.get(ctx) != null) {
                return;
            }
            script = this.src.get();
            this.registeredSource.put(ctx, script);
        }
        this.instrument.ignoreSources.ignoreSource(script);
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.collectSymbols(argNames, args);
        try {
            target = this.instrument.env().parse(script, argNames.toArray(new String[0]));
        }
        catch (Exception ex) {
            throw InsightException.raise(ex);
        }
        target.call(args.toArray());
    }

    public void onContextCreated(TruffleContext context) {
    }

    public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
    }

    public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
        if (this.agentBinding != null || language.isInternal()) {
            return;
        }
        if (context.isEntered()) {
            this.initializeAgent(context);
        } else {
            SourceSectionFilter anyRoot = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build();
            Instrumenter instrumenter = this.instrument.env().getInstrumenter();
            this.agentBinding = instrumenter.attachExecutionEventListener(anyRoot, (ExecutionEventListener)new InitializeLater(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
        InsightInstrument.Key closingKey;
        InsightPerSource insightPerSource = this;
        synchronized (insightPerSource) {
            closingKey = this.closeBinding;
        }
        if (closingKey != null) {
            this.instrument.find(context).onClosed(closingKey);
        }
    }

    public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
    }

    public void onContextClosed(TruffleContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        InsightInstrument.Key[] keys;
        InsightPerSource insightPerSource = this;
        synchronized (insightPerSource) {
            if (this.bindings == null) {
                return;
            }
            keys = this.bindings.values().toArray(new InsightInstrument.Key[0]);
            this.bindings = null;
        }
        this.onInit.dispose();
        EventBinding<?> agentInitBinding = this.agentBinding;
        if (agentInitBinding != null) {
            agentInitBinding.dispose();
        }
        this.agentBinding = null;
        this.instrument.closeKeys(keys);
    }

    private void checkClosed() throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.bindings == null) {
            CompilerDirectives.transferToInterpreter();
            throw InsightException.alreadyClosed();
        }
    }

    synchronized void binding(InsightFilter.Data data, Function<InsightInstrument.Key, ExecutionEventNodeFactory> needFactory, Consumer<InsightInstrument.Key> hasFactory) {
        this.checkClosed();
        InsightFilter filter = data.filter;
        InsightInstrument.Key key = this.bindings.get(filter);
        if (key == null) {
            key = this.instrument.newKey(null);
            SourceSectionFilter.Builder ssfb = SourceSectionFilter.newBuilder().sourceIs((SourceSectionFilter.SourcePredicate)this.ignoredSources).includeInternal(false).tagIs((Class[])filter.getTags());
            if (data.sourceFilterFn != null) {
                InsightSourceFilter predicate = new InsightSourceFilter(this.instrument, key);
                SourceFilter sf = SourceFilter.newBuilder().sourceIs((Predicate)predicate).build();
                ssfb.sourceFilter(sf);
            }
            if (filter.getRootNameRegExp() != null) {
                ssfb.rootNameIs((Predicate)new RegexNameFilter(filter.getRootNameRegExp()));
            } else if (data.rootNameFn != null) {
                ssfb.rootNameIs((Predicate)new RootNameFilter(this.instrument, key));
            }
            this.bindings.put(filter, key);
            Instrumenter instrumenter = this.instrument.env().getInstrumenter();
            EventBinding handle = instrumenter.attachExecutionEventFactory(ssfb.build(), needFactory.apply(key));
            key.assign(handle);
        } else {
            hasFactory.accept(key);
        }
    }

    synchronized InsightInstrument.Key closeBinding() {
        this.checkClosed();
        if (this.closeBinding == null) {
            this.closeBinding = this.instrument.newKey(AgentType.CLOSE);
            this.bindings.put((Object)AgentType.CLOSE, this.closeBinding);
        }
        return this.closeBinding;
    }

    synchronized InsightInstrument.Key sourceBinding() {
        this.checkClosed();
        if (this.sourceBinding == null) {
            SourceFilter filter = SourceFilter.newBuilder().sourceIs((Predicate)((Object)this.ignoredSources)).includeInternal(false).build();
            Instrumenter instrumenter = this.instrument.env().getInstrumenter();
            this.sourceBinding = this.instrument.newKey(AgentType.SOURCE).assign(instrumenter.attachLoadSourceListener(filter, (LoadSourceListener)this, false));
            this.bindings.put((Object)AgentType.SOURCE, this.sourceBinding);
        }
        return this.sourceBinding;
    }

    public void onLoad(LoadSourceEvent event) {
        InteropLibrary interop = InteropLibrary.getUncached();
        Instrumenter instrumenter = this.instrument.env().getInstrumenter();
        int len = this.sourceBinding.functionsMaxCount();
        for (int i = 0; i < len; ++i) {
            Object fn = this.instrument.findCtx().functionFor(this.sourceBinding, i);
            if (fn == null) continue;
            Source source = event.getSource();
            try {
                interop.execute(fn, new Object[]{new SourceEventObject(source)});
                continue;
            }
            catch (RuntimeException ex) {
                if (interop.isException((Object)ex)) {
                    InsightException.throwWhenExecuted(instrumenter, source, ex);
                    continue;
                }
                throw ex;
            }
            catch (InteropException ex) {
                InsightException.throwWhenExecuted(instrumenter, source, (Exception)((Object)ex));
            }
        }
    }

    final class InitializeLater
    implements ExecutionEventListener {
        private final TruffleContext context;

        InitializeLater(TruffleContext context) {
            this.context = context;
        }

        public void onEnter(EventContext ctx, VirtualFrame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EventBinding agentInitBinding = InsightPerSource.this.agentBinding;
            if (agentInitBinding != null) {
                agentInitBinding.dispose();
            }
            InsightPerSource.this.initializeAgent(this.context);
        }

        public void onReturnValue(EventContext ctx, VirtualFrame frame, Object result) {
        }

        public void onReturnExceptional(EventContext ctx, VirtualFrame frame, Throwable exception) {
        }
    }
}

