/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class InsightFilter {
    private final List<Class<? extends Tag>> allTags;
    private final String rootNameRegExp;
    private final boolean rootNameFn;
    private final boolean sourceFilterFn;

    private InsightFilter(List<Class<? extends Tag>> allTags, String rootNameRegExp, boolean rootNameFn, boolean sourceFilterFn) {
        this.allTags = allTags;
        this.rootNameRegExp = rootNameRegExp;
        this.rootNameFn = rootNameFn;
        this.sourceFilterFn = sourceFilterFn;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.allTags);
        hash = 79 * hash + Objects.hashCode(this.rootNameRegExp);
        hash = 79 * hash + (this.rootNameFn ? 1 : 0);
        hash = 79 * hash + (this.sourceFilterFn ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InsightFilter other = (InsightFilter)obj;
        if (this.rootNameFn != other.rootNameFn) {
            return false;
        }
        if (this.sourceFilterFn != other.sourceFilterFn) {
            return false;
        }
        if (!Objects.equals(this.rootNameRegExp, other.rootNameRegExp)) {
            return false;
        }
        return Objects.equals(this.allTags, other.allTags);
    }

    Class<?>[] getTags() {
        return this.allTags.toArray(new Class[0]);
    }

    String getRootNameRegExp() {
        return this.rootNameRegExp;
    }

    static Data create(AgentType at, Object[] arr) throws IllegalArgumentException, UnsupportedMessageException {
        ArrayList<Class<? extends Tag>> allTags = new ArrayList<Class<? extends Tag>>();
        String rootNameRegExp = null;
        Object rootNameFn = null;
        Object sourceFilterFn = null;
        if (arr != null && arr.length > 2) {
            Object config = arr[2];
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (iop.hasHashEntries(config)) {
                Object it = iop.getHashEntriesIterator(config);
                while (iop.hasIteratorNextElement(it)) {
                    try {
                        Object value;
                        Object key;
                        Object keyAndValue = iop.getIteratorNextElement(it);
                        try {
                            key = iop.readArrayElement(keyAndValue, 0L);
                            value = iop.readArrayElement(keyAndValue, 1L);
                        }
                        catch (InvalidArrayIndexException ex) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                        }
                        String type = iop.asString(key);
                        map.put(type, value);
                    }
                    catch (StopIterationException ex) {
                        break;
                    }
                }
            } else {
                Object allMembers = iop.getMembers(config, false);
                long allMembersSize = iop.getArraySize(allMembers);
                int i = 0;
                while ((long)i < allMembersSize) {
                    block33: {
                        Object value;
                        Object atI;
                        try {
                            atI = iop.readArrayElement(allMembers, (long)i);
                        }
                        catch (InvalidArrayIndexException ex) {
                            break block33;
                        }
                        String type = iop.asString(atI);
                        try {
                            value = iop.readMember(config, type);
                        }
                        catch (UnknownIdentifierException ex) {
                            break block33;
                        }
                        map.put(type, value);
                    }
                    ++i;
                }
            }
            block24: for (Map.Entry entry : map.entrySet()) {
                String type;
                switch (type = (String)entry.getKey()) {
                    case "expressions": {
                        if (!InsightFilter.isSet(iop, map, "expressions")) continue block24;
                        allTags.add(StandardTags.ExpressionTag.class);
                        continue block24;
                    }
                    case "statements": {
                        if (!InsightFilter.isSet(iop, map, "statements")) continue block24;
                        allTags.add(StandardTags.StatementTag.class);
                        continue block24;
                    }
                    case "roots": {
                        if (!InsightFilter.isSet(iop, map, "roots")) continue block24;
                        allTags.add(StandardTags.RootBodyTag.class);
                        continue block24;
                    }
                    case "rootNameFilter": {
                        Object fn = map.get("rootNameFilter");
                        if (fn == null || iop.isNull(fn)) continue block24;
                        if (iop.isString(fn)) {
                            rootNameRegExp = iop.asString(fn);
                            continue block24;
                        }
                        if (!iop.isExecutable(fn)) {
                            throw new IllegalArgumentException("rootNameFilter should be a string, a regular expression!");
                        }
                        rootNameFn = fn;
                        continue block24;
                    }
                    case "sourceFilter": {
                        Object fn = map.get("sourceFilter");
                        if (fn == null || iop.isNull(fn)) continue block24;
                        if (!iop.isExecutable(fn)) {
                            throw new IllegalArgumentException("sourceFilter has to be a function!");
                        }
                        sourceFilterFn = fn;
                        continue block24;
                    }
                }
                throw InsightException.unknownAttribute(type);
            }
        }
        if (allTags.isEmpty()) {
            throw new IllegalArgumentException("No elements specified to listen to for execution listener. Need to specify at least one element kind: expressions, statements or roots.");
        }
        allTags.sort((c1, c2) -> c1.getName().compareTo(c2.getName()));
        InsightFilter filter = new InsightFilter(allTags, rootNameRegExp, rootNameFn != null, sourceFilterFn != null);
        return new Data(at, filter, arr[1], rootNameFn, sourceFilterFn);
    }

    private static boolean isSet(InteropLibrary iop, Map<String, Object> map, String property) {
        Object value = map.get(property);
        try {
            return iop.isBoolean(value) && iop.asBoolean(value);
        }
        catch (UnsupportedMessageException ex) {
            return false;
        }
    }

    public static final class Data {
        final AgentType type;
        final InsightFilter filter;
        final Object fn;
        final Object rootNameFn;
        final Object sourceFilterFn;

        private Data(AgentType type, InsightFilter filter, Object fn, Object rootNameFn, Object sourceFilterFn) {
            this.type = type;
            this.filter = filter;
            this.fn = fn;
            this.rootNameFn = rootNameFn;
            this.sourceFilterFn = sourceFilterFn;
        }
    }
}

