/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextLocal;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentObject;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.IgnoreSources;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrumentOptionDescriptors;
import com.oracle.truffle.tools.agentscript.impl.InsightPerContext;
import com.oracle.truffle.tools.agentscript.impl.InsightPerSource;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.file.LinkOption;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.tools.insight.Insight;

@TruffleInstrument.Registration(id="insight", name="Insight", version="1.1", services={Function.class})
public class InsightInstrument
extends TruffleInstrument {
    static final String NAME = "Insight";
    @Option(stability=OptionStability.STABLE, name="", help="Use provided file as an insight script", category=OptionCategory.USER)
    static final OptionKey<String> SCRIPT = new OptionKey((Object)"");
    final IgnoreSources ignoreSources = new IgnoreSources();
    final ContextLocal<InsightPerContext> perContextData;
    private TruffleInstrument.Env env;
    private final BitSet keys = new BitSet();
    @CompilerDirectives.CompilationFinal
    private Assumption keysUnchanged;

    public InsightInstrument() {
        this.perContextData = this.createContextLocal(context -> new InsightPerContext(this, context));
        this.keysUnchanged = Truffle.getRuntime().createAssumption();
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new InsightInstrumentOptionDescriptors();
    }

    protected void onCreate(TruffleInstrument.Env tmp) {
        this.env = tmp;
        Function<?, ?> registerScripts = InsightInstrument.registerScriptsAPI(this);
        this.env.registerService(registerScripts);
        String path = (String)this.env.getOptions().get(this.option());
        if (path != null && path.length() > 0) {
            this.registerAgentScript(() -> {
                try {
                    TruffleFile file = this.env.getTruffleFile(path);
                    if (file == null || !file.exists(new LinkOption[0])) {
                        throw InsightException.notFound(file);
                    }
                    String mimeType = file.detectMimeType();
                    String lang = null;
                    for (Map.Entry e : this.env.getLanguages().entrySet()) {
                        if (mimeType == null || !((LanguageInfo)e.getValue()).getMimeTypes().contains(mimeType)) continue;
                        lang = (String)e.getKey();
                        break;
                    }
                    if (lang == null) {
                        throw InsightException.notRecognized(file);
                    }
                    return Source.newBuilder(lang, (TruffleFile)file).uri(file.toUri()).name(file.getName()).build();
                }
                catch (IOException ex) {
                    throw InsightException.raise(ex);
                }
            });
        }
    }

    OptionKey<String> option() {
        return SCRIPT;
    }

    final TruffleInstrument.Env env() {
        return this.env;
    }

    final AutoCloseable registerAgentScript(Supplier<Source> src) {
        return new InsightPerSource(this.env.getInstrumenter(), this, src, this.ignoreSources);
    }

    protected void onDispose(TruffleInstrument.Env tmp) {
    }

    AgentObject createInsightObject(InsightPerSource source) {
        return new AgentObject(null, this, source);
    }

    void collectGlobalSymbolsImpl(InsightPerSource source, List<String> argNames, List<Object> args) {
        for (InstrumentInfo item : this.env.getInstruments().values()) {
            Insight.SymbolProvider provider;
            if (NAME.equals(item.getName()) || (provider = (Insight.SymbolProvider)this.env.lookup(item, Insight.SymbolProvider.class)) == null) continue;
            try {
                for (Map.Entry<String, ? extends Object> e : provider.symbolsWithValues().entrySet()) {
                    if (e.getValue() == null) continue;
                    if (argNames.contains(e.getKey())) {
                        throw InsightException.unknownAttribute(e.getKey());
                    }
                    argNames.add(e.getKey());
                    args.add(e.getValue());
                }
            }
            catch (Exception ex) {
                throw InsightException.raise(ex);
            }
        }
    }

    private static Function<?, ?> registerScriptsAPI(InsightInstrument insight) {
        Function<org.graalvm.polyglot.Source, AutoCloseable> f = text -> {
            Source.LiteralBuilder b = Source.newBuilder((String)text.getLanguage(), (CharSequence)text.getCharacters(), (String)text.getName());
            b.uri(text.getURI());
            b.mimeType(text.getMimeType());
            b.internal(text.isInternal());
            b.interactive(text.isInteractive());
            Source src = b.build();
            return insight.registerAgentScript(() -> src);
        };
        return InsightInstrument.maybeProxy(Function.class, f);
    }

    static <Interface> Interface maybeProxy(Class<Interface> type, Interface delegate) {
        if (TruffleOptions.AOT) {
            return delegate;
        }
        return InsightInstrument.proxy(type, delegate);
    }

    private static <Interface> Interface proxy(Class<Interface> type, Interface delegate) {
        InvocationHandler handler = (proxy, method, args) -> {
            try {
                return method.invoke(delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        };
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler));
    }

    final InsightPerContext find(TruffleContext ctx) {
        return (InsightPerContext)this.perContextData.get(ctx);
    }

    final InsightPerContext findCtx() {
        return (InsightPerContext)this.perContextData.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Key newKey(AgentType type) {
        BitSet bitSet = this.keys;
        synchronized (bitSet) {
            int index = this.keys.nextClearBit(0);
            this.invalidateKeys(index, -1);
            return new Key(type, index);
        }
    }

    private void invalidateKeys(int set, int clear) {
        assert (Thread.holdsLock(this.keys));
        if (set != -1) {
            this.keys.set(set);
        }
        if (clear != -1) {
            this.keys.clear(clear);
        }
        this.keysUnchanged.invalidate();
    }

    synchronized Assumption keysUnchangedAssumption() {
        if (!this.keysUnchanged.isValid()) {
            this.keysUnchanged = Truffle.getRuntime().createAssumption("Keys[" + this.keys + "]");
        }
        return this.keysUnchanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int keysLength() {
        BitSet bitSet = this.keys;
        synchronized (bitSet) {
            return this.keys.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeKeys(Key ... noLongerNeededKeys) {
        BitSet bitSet = this.keys;
        synchronized (bitSet) {
            for (Key k : noLongerNeededKeys) {
                k.close();
            }
        }
    }

    final class Key {
        @CompilerDirectives.CompilationFinal
        private int index;
        @CompilerDirectives.CompilationFinal
        private int functionsMaxLen;
        private final AgentType type;
        private EventBinding<?> binding;

        private Key(AgentType type, int index) {
            if (index < 0) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Key assign(EventBinding<?> b) {
            BitSet bitSet = InsightInstrument.this.keys;
            synchronized (bitSet) {
                this.binding = b;
                return this;
            }
        }

        int index() {
            return this.index;
        }

        int functionsMaxCount() {
            return this.functionsMaxLen;
        }

        public String toString() {
            return "Key[" + this.index + "@" + (Object)((Object)this.type) + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            EventBinding<?> b;
            BitSet bitSet = InsightInstrument.this.keys;
            synchronized (bitSet) {
                b = this.binding;
                this.binding = null;
                CompilerAsserts.neverPartOfCompilation();
                this.index = -1;
            }
            if (b != null) {
                b.dispose();
            }
        }

        void adjustSize(int size) {
            if (size > this.functionsMaxLen) {
                this.functionsMaxLen = size;
                InsightInstrument.this.keysUnchanged.invalidate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isClosed() {
            BitSet bitSet = InsightInstrument.this.keys;
            synchronized (bitSet) {
                return this.index == -1;
            }
        }
    }
}

