/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.EventContextObject;
import java.util.Locale;

@ExportLibrary(value=InteropLibrary.class)
final class InsightException
extends AbstractTruffleException {
    static final long serialVersionUID = 1L;
    private final int exitCode;

    @CompilerDirectives.TruffleBoundary
    private InsightException(String msg, Throwable cause, int exitCode) {
        super("insight: " + msg, cause, -1, null);
        this.exitCode = exitCode;
    }

    @CompilerDirectives.TruffleBoundary
    private InsightException(Throwable cause, Node node) {
        super(cause.getMessage(), node);
        this.exitCode = -1;
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return this.exitCode < 0 ? ExceptionType.RUNTIME_ERROR : ExceptionType.EXIT;
    }

    @ExportMessage
    int getExceptionExitStatus() throws UnsupportedMessageException {
        if (this.exitCode < 0) {
            throw UnsupportedMessageException.create();
        }
        return this.exitCode;
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException raise(Exception ex) throws InsightException {
        String msg = ex.getMessage() == null ? "Unexpected " + ex.getClass().getSimpleName() : ex.getMessage().replace(System.lineSeparator(), ": ");
        throw new InsightException(msg, ex, -1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException notFound(TruffleFile file) {
        throw new InsightException(file.getName() + ": No such file or directory", null, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException notRecognized(TruffleFile file) {
        throw new InsightException(file.getName() + ": No language to process the file. Try --polyglot", null, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException unknownAttribute(String type) {
        throw new InsightException("Unknown attribute " + type, null, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException unknownType(Throwable originalError, String str, AgentType[] values) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown event type '").append(str).append("'. Known types are:");
        String sep = " ";
        for (AgentType t : values) {
            sb.append(sep).append("'").append(t.toString().toLowerCase(Locale.ENGLISH)).append("'");
            sep = ", ";
        }
        throw new InsightException(sb.toString(), originalError, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException alreadyClosed() {
        throw new InsightException("The script has already been closed", null, -1);
    }

    @CompilerDirectives.TruffleBoundary
    static void throwWhenExecuted(Instrumenter instrumenter, Source source, final Exception ex) {
        TruffleStackTrace.getStackTrace((Throwable)ex);
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{source}).build();
        final EventBinding[] waitForSourceBeingExecuted = new EventBinding[]{null};
        waitForSourceBeingExecuted[0] = instrumenter.attachExecutionEventListener(filter, new ExecutionEventListener(){

            @CompilerDirectives.TruffleBoundary
            public void onEnter(EventContext context, VirtualFrame frame) {
                waitForSourceBeingExecuted[0].dispose();
                InteropLibrary interopLib = InteropLibrary.getUncached();
                if (interopLib.isException((Object)ex)) {
                    throw EventContextObject.rethrow((RuntimeException)ex, interopLib);
                }
                InsightException wrapper = new InsightException(ex, context.getInstrumentedNode());
                throw EventContextObject.rethrow((RuntimeException)((Object)wrapper), interopLib);
            }

            public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
            }

            public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            }
        });
    }
}

