// CheckStyle: start generated
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.tools.agentscript.FrameLibrary;
import com.oracle.truffle.tools.agentscript.FrameLibrary.Query;

@GeneratedBy(DefaultFrameLibrary.class)
final class DefaultFrameLibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(DefaultFrameLibrary.class, new FrameLibraryExports());
    }

    private DefaultFrameLibraryGen() {
    }

    @GeneratedBy(DefaultFrameLibrary.class)
    private static final class FrameLibraryExports extends LibraryExport<FrameLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private FrameLibraryExports() {
            super(FrameLibrary.class, Query.class, true, false, 0);
        }

        @Override
        protected FrameLibrary createUncached(Object receiver) {
            assert receiver instanceof Query;
            FrameLibrary uncached = FrameLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected FrameLibrary createCached(Object receiver) {
            assert receiver instanceof Query;
            return FrameLibraryExports.CACHE;
        }

        @GeneratedBy(DefaultFrameLibrary.class)
        private static final class Cached extends FrameLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Query) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Query;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(DefaultFrameLibrary.class)
        private static final class Uncached extends FrameLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Query) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Query;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

        }
    }
}
