/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentObject;
import com.oracle.truffle.tools.agentscript.impl.IgnoreSources;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrumentOptionDescriptors;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.tools.insight.Insight;

@TruffleInstrument.Registration(id="insight", name="Insight", version="1.1", services={Function.class})
public class InsightInstrument
extends TruffleInstrument {
    static final String NAME = "Insight";
    @Option(stability=OptionStability.STABLE, name="", help="Use provided file as an insight script", category=OptionCategory.USER)
    static final OptionKey<String> SCRIPT = new OptionKey((Object)"");
    private TruffleInstrument.Env env;
    private final IgnoreSources ignoreSources = new IgnoreSources();

    protected OptionDescriptors getOptionDescriptors() {
        return new InsightInstrumentOptionDescriptors();
    }

    protected void onCreate(TruffleInstrument.Env tmp) {
        this.env = tmp;
        Function<?, ?> registerScripts = InsightInstrument.registerScriptsAPI(this);
        this.env.registerService(registerScripts);
        String path = (String)this.env.getOptions().get(this.option());
        if (path != null && path.length() > 0) {
            this.registerAgentScript(() -> {
                try {
                    TruffleFile file = this.env.getTruffleFile(path);
                    if (file == null || !file.exists(new LinkOption[0])) {
                        throw InsightException.notFound(file);
                    }
                    String mimeType = file.detectMimeType();
                    String lang = null;
                    for (Map.Entry e : this.env.getLanguages().entrySet()) {
                        if (mimeType == null || !((LanguageInfo)e.getValue()).getMimeTypes().contains(mimeType)) continue;
                        lang = (String)e.getKey();
                        break;
                    }
                    if (lang == null) {
                        throw InsightException.notRecognized(file);
                    }
                    return Source.newBuilder(lang, (TruffleFile)file).uri(file.toUri()).name(file.getName()).build();
                }
                catch (IOException ex) {
                    throw InsightException.raise(ex);
                }
            });
        }
    }

    OptionKey<String> option() {
        return SCRIPT;
    }

    boolean onlyInsight() {
        return true;
    }

    final AutoCloseable registerAgentScript(final Supplier<Source> src) {
        final Instrumenter instrumenter = this.env.getInstrumenter();
        class InitializeAgent
        implements ContextsListener,
        AutoCloseable {
            private AgentObject insight;
            private AgentObject agent;
            private EventBinding<?> agentBinding;

            InitializeAgent() {
            }

            @CompilerDirectives.TruffleBoundary
            synchronized boolean initializeAgentObject() {
                if (this.insight == null) {
                    AgentObject.Data sharedData = new AgentObject.Data();
                    this.insight = new AgentObject(null, InsightInstrument.this.env, InsightInstrument.this.ignoreSources, sharedData);
                    if (!InsightInstrument.this.onlyInsight()) {
                        this.agent = new AgentObject("Warning: 'agent' is deprecated. Use 'insight'.\n", InsightInstrument.this.env, InsightInstrument.this.ignoreSources, sharedData);
                    }
                    return true;
                }
                return false;
            }

            @CompilerDirectives.TruffleBoundary
            void initializeAgent() {
                if (this.initializeAgentObject()) {
                    CallTarget target;
                    Source script = (Source)src.get();
                    InsightInstrument.this.ignoreSources.ignoreSource(script);
                    ArrayList<String> argNames = new ArrayList<String>();
                    ArrayList<Object> args = new ArrayList<Object>();
                    argNames.add("insight");
                    args.add(this.insight);
                    if (this.agent != null) {
                        argNames.add("agent");
                        args.add(this.agent);
                    } else {
                        this.collectGlobalSymbols(InsightInstrument.this.env.getInstruments().values(), (instrument, type) -> InsightInstrument.NAME.equals(instrument.getName()) ? null : (Insight.SymbolProvider)InsightInstrument.this.env.lookup(instrument, type), argNames, args);
                    }
                    try {
                        target = InsightInstrument.this.env.parse(script, argNames.toArray(new String[0]));
                    }
                    catch (Exception ex) {
                        throw InsightException.raise(ex);
                    }
                    target.call(args.toArray());
                }
            }

            public void onContextCreated(TruffleContext context) {
            }

            public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
                if (this.agentBinding != null || language.isInternal()) {
                    return;
                }
                if (context.isEntered()) {
                    this.initializeAgent();
                } else {
                    SourceSectionFilter anyRoot = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build();
                    class InitializeLater
                    implements ExecutionEventListener {
                        InitializeLater() {
                        }

                        public void onEnter(EventContext ctx, VirtualFrame frame) {
                            CompilerDirectives.transferToInterpreter();
                            agentBinding.dispose();
                            this.initializeAgent();
                        }

                        public void onReturnValue(EventContext ctx, VirtualFrame frame, Object result) {
                        }

                        public void onReturnExceptional(EventContext ctx, VirtualFrame frame, Throwable exception) {
                        }
                    }
                    this.agentBinding = instrumenter.attachExecutionEventListener(anyRoot, (ExecutionEventListener)new InitializeLater());
                }
            }

            public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
                if (this.agent != null) {
                    this.agent.onClosed();
                }
                if (this.insight != null) {
                    this.insight.onClosed();
                }
            }

            public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
            }

            public void onContextClosed(TruffleContext context) {
            }

            @Override
            public void close() {
                if (this.agent != null) {
                    this.agent.onClosed();
                }
                if (this.insight != null) {
                    this.insight.onClosed();
                }
                if (this.agentBinding != null) {
                    this.agentBinding.dispose();
                }
            }

            private <T> void collectGlobalSymbols(Collection<T> values, BiFunction<T, Class<Insight.SymbolProvider>, Insight.SymbolProvider> check, List<String> argNames, List<Object> args) {
                for (T item : values) {
                    Insight.SymbolProvider provider = check.apply(item, Insight.SymbolProvider.class);
                    if (provider == null) continue;
                    try {
                        for (Map.Entry<String, ? extends Object> e : provider.symbolsWithValues().entrySet()) {
                            if (e.getValue() == null) continue;
                            if (argNames.contains(e.getKey())) {
                                throw InsightException.unknownAttribute(e.getKey());
                            }
                            argNames.add(e.getKey());
                            args.add(e.getValue());
                        }
                    }
                    catch (Exception ex) {
                        throw InsightException.raise(ex);
                    }
                }
            }
        }
        InitializeAgent initializeAgent = new InitializeAgent();
        instrumenter.attachContextsListener((ContextsListener)initializeAgent, true);
        return initializeAgent;
    }

    protected void onDispose(TruffleInstrument.Env tmp) {
    }

    private static Function<?, ?> registerScriptsAPI(InsightInstrument insight) {
        Function<org.graalvm.polyglot.Source, AutoCloseable> f = text -> {
            Source.LiteralBuilder b = Source.newBuilder((String)text.getLanguage(), (CharSequence)text.getCharacters(), (String)text.getName());
            b.uri(text.getURI());
            b.mimeType(text.getMimeType());
            b.internal(text.isInternal());
            b.interactive(text.isInteractive());
            Source src = b.build();
            return insight.registerAgentScript(() -> src);
        };
        return InsightInstrument.maybeProxy(Function.class, f);
    }

    static <Interface> Interface maybeProxy(Class<Interface> type, Interface delegate) {
        if (TruffleOptions.AOT) {
            return delegate;
        }
        return InsightInstrument.proxy(type, delegate);
    }

    private static <Interface> Interface proxy(Class<Interface> type, Interface delegate) {
        InvocationHandler handler = (proxy, method, args) -> {
            try {
                return method.invoke(delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        };
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler));
    }
}

