/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.EventContextObject;
import com.oracle.truffle.tools.agentscript.impl.NullObject;
import com.oracle.truffle.tools.agentscript.impl.VariablesObject;

final class AgentExecutionNode
extends ExecutionEventNode {
    @Node.Child
    private InteropLibrary enterDispatch;
    @Node.Child
    private InteropLibrary exitDispatch;
    @Node.Child
    private NodeLibrary nodeDispatch;
    @Node.Child
    private InteropLibrary exceptionDispatch;
    private final Object enter;
    private final Object exit;
    private final EventContextObject ctx;
    private final Node instrumentedNode;

    AgentExecutionNode(Object enter, Object exit, EventContextObject ctx) {
        this.enter = enter;
        if (enter != null) {
            this.enterDispatch = (InteropLibrary)InteropLibrary.getFactory().create(enter);
        }
        this.exit = exit;
        if (exit != null) {
            this.exitDispatch = (InteropLibrary)InteropLibrary.getFactory().create(exit);
        }
        Node node = ctx.getInstrumentedNode();
        this.nodeDispatch = (NodeLibrary)NodeLibrary.getFactory().create((Object)node);
        if (enter != null || exit != null) {
            this.exceptionDispatch = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        }
        this.ctx = ctx;
        this.instrumentedNode = node;
    }

    protected void onEnter(VirtualFrame frame) {
        if (this.enter != null) {
            try {
                this.enterDispatch.execute(this.enter, new Object[]{this.ctx, this.getVariables(frame, true, null)});
            }
            catch (InteropException ex) {
                throw this.ctx.wrap(this.enter, 2, ex);
            }
            catch (RuntimeException ex) {
                throw this.ctx.rethrow(ex, this.exceptionDispatch);
            }
        }
    }

    protected void onReturnValue(VirtualFrame frame, Object returnValue) {
        if (this.exit != null) {
            try {
                this.exitDispatch.execute(this.exit, new Object[]{this.ctx, this.getVariables(frame, false, returnValue)});
            }
            catch (InteropException ex) {
                throw this.ctx.wrap(this.exit, 2, ex);
            }
            catch (RuntimeException ex) {
                throw this.ctx.rethrow(ex, this.exceptionDispatch);
            }
        }
    }

    protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
        if (this.exit != null) {
            try {
                this.exitDispatch.execute(this.exit, new Object[]{this.ctx, this.getVariables(frame, false, null)});
            }
            catch (InteropException ex) {
                throw this.ctx.wrap(this.exit, 2, ex);
            }
            catch (RuntimeException ex) {
                throw this.ctx.rethrow(ex, this.exceptionDispatch);
            }
        }
    }

    protected Object onUnwind(VirtualFrame frame, Object info) {
        return info;
    }

    static ThreadDeath returnNow(EventContext context, Object[] args) throws ArityException, ThreadDeath {
        Object returnValue;
        switch (args.length) {
            case 0: {
                returnValue = null;
                break;
            }
            case 1: {
                returnValue = args[0];
                break;
            }
            default: {
                throw ArityException.create((int)1, (int)1, (int)args.length);
            }
        }
        return context.createUnwind(NullObject.nullCheck(returnValue));
    }

    private Object getVariables(VirtualFrame frame, boolean nodeEnter, Object returnValue) {
        if (this.nodeDispatch.hasScope((Object)this.instrumentedNode, (Frame)frame)) {
            try {
                Object scope = this.nodeDispatch.getScope((Object)this.instrumentedNode, (Frame)frame, nodeEnter);
                if (returnValue != null) {
                    return new VariablesObject(scope, returnValue);
                }
                return scope;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return ArrayObject.array(new String[0]);
    }

    static ExecutionEventNodeFactory factory(final Object enter, final Object exit) {
        return new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext context) {
                EventContextObject ctx = new EventContextObject(context);
                return new AgentExecutionNode(enter, exit, ctx);
            }
        };
    }
}

