/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.NullObject;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;

abstract class AbstractContextObject
implements TruffleObject {
    static final ArrayObject MEMBERS = ArrayObject.array("name", "source", "characters", "line", "startLine", "endLine", "column", "startColumn", "endColumn", "charIndex", "charLength", "charEndIndex");
    @CompilerDirectives.CompilationFinal
    private String name;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] values;

    AbstractContextObject() {
    }

    abstract Node getInstrumentedNode();

    abstract SourceSection getInstrumentedSourceSection();

    Object readMember(String member) throws UnknownIdentifierException {
        int index;
        switch (member) {
            case "name": {
                if (this.name == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.name = this.getInstrumentedNode().getRootNode().getName();
                }
                return this.name;
            }
            case "characters": {
                CompilerDirectives.transferToInterpreter();
                SourceSection ss = this.getInstrumentedSourceSection();
                if (ss == null) {
                    return NullObject.nullCheck(null);
                }
                return ss.getCharacters().toString();
            }
            case "source": {
                SourceSection ss = this.getInstrumentedSourceSection();
                if (ss == null) {
                    return NullObject.nullCheck(null);
                }
                return new SourceEventObject(ss.getSource());
            }
            case "line": 
            case "startLine": {
                index = 0;
                break;
            }
            case "endLine": {
                index = 1;
                break;
            }
            case "column": 
            case "startColumn": {
                index = 2;
                break;
            }
            case "endColumn": {
                index = 3;
                break;
            }
            case "charIndex": {
                index = 4;
                break;
            }
            case "charLength": {
                index = 5;
                break;
            }
            case "charEndIndex": {
                index = 6;
                break;
            }
            default: {
                throw UnknownIdentifierException.create((String)member);
            }
        }
        if (this.values == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.values = this.valuesForContext();
        }
        return this.values[index];
    }

    @CompilerDirectives.TruffleBoundary
    private int[] valuesForContext() {
        SourceSection section = this.getInstrumentedSourceSection();
        if (section == null) {
            return new int[7];
        }
        return new int[]{section.getStartLine(), section.getEndLine(), section.getStartColumn(), section.getEndColumn(), section.getCharIndex(), section.getCharLength(), section.getCharEndIndex()};
    }
}

