/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

final class RootNameFilter
implements Predicate<String> {
    private final Object fn;
    private final ThreadLocal<Boolean> querying;
    private final Map<String, Boolean> cache;

    RootNameFilter(Object fn) {
        this.fn = fn;
        this.querying = new ThreadLocal();
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean test(String rootName) {
        if (rootName == null) {
            return false;
        }
        Boolean computed = this.cache.get(rootName);
        if (computed != null) {
            return computed;
        }
        Boolean prev = this.querying.get();
        try {
            if (Boolean.TRUE.equals(prev)) {
                computed = false;
            } else {
                this.querying.set(true);
                InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
                Object res = iop.execute(this.fn, new Object[]{rootName});
                computed = (Boolean)res;
            }
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException ex) {
            computed = false;
        }
        finally {
            this.querying.set(prev);
        }
        this.cache.put(rootName, computed);
        return computed;
    }
}

