/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentExecutionNode;
import com.oracle.truffle.tools.agentscript.impl.AgentSourceFilter;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.IgnoreSources;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.RegexNameFilter;
import com.oracle.truffle.tools.agentscript.impl.RootNameFilter;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

@ExportLibrary(value=InteropLibrary.class)
final class AgentObject
implements TruffleObject {
    private final TruffleInstrument.Env env;
    private final IgnoreSources excludeSources;
    private final Data data;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] msg;

    AgentObject(String msg, TruffleInstrument.Env env, IgnoreSources excludeSources, Data data) {
        this.msg = msg == null ? null : msg.getBytes();
        this.env = env;
        this.excludeSources = excludeSources;
        this.data = data;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        return true;
    }

    @ExportMessage
    static boolean hasMembers(AgentObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(AgentObject obj, boolean includeInternal) {
        return ArrayObject.array("id", "version");
    }

    @ExportMessage
    Object readMember(String name) throws UnknownIdentifierException {
        this.warnMsg();
        switch (name) {
            case "id": {
                return "insight";
            }
            case "version": {
                return "0.7";
            }
        }
        throw UnknownIdentifierException.create((String)name);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Object invokeMember(AgentObject obj, String member, final Object[] args, final @CachedLibrary(limit="0") InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException {
        obj.warnMsg();
        final Instrumenter instrumenter = obj.env.getInstrumenter();
        block4 : switch (member) {
            case "on": {
                AgentType type = AgentType.find(AgentObject.convertToString(interop, args[0]));
                switch (type) {
                    case SOURCE: {
                        SourceFilter filter = SourceFilter.newBuilder().sourceIs((Predicate)((Object)obj.excludeSources)).includeInternal(false).build();
                        EventBinding handle = instrumenter.attachLoadSourceListener(filter, new LoadSourceListener(){

                            public void onLoad(LoadSourceEvent event) {
                                Source source = event.getSource();
                                try {
                                    interop.execute(args[1], new Object[]{new SourceEventObject(source)});
                                }
                                catch (RuntimeException ex) {
                                    if (interop.isException((Object)ex)) {
                                        InsightException.throwWhenExecuted(instrumenter, source, ex);
                                    }
                                    throw ex;
                                }
                                catch (InteropException ex) {
                                    InsightException.throwWhenExecuted(instrumenter, source, (Exception)((Object)ex));
                                }
                            }
                        }, false);
                        obj.data.registerHandle(type, handle, args[1]);
                        break block4;
                    }
                    case ENTER: {
                        CompilerDirectives.transferToInterpreter();
                        SourceSectionFilter filter = AgentObject.createFilter(obj, args);
                        EventBinding handle = instrumenter.attachExecutionEventFactory(filter, AgentExecutionNode.factory(args[1], null));
                        obj.data.registerHandle(type, handle, args[1]);
                        break block4;
                    }
                    case RETURN: {
                        CompilerDirectives.transferToInterpreter();
                        SourceSectionFilter filter = AgentObject.createFilter(obj, args);
                        EventBinding handle = instrumenter.attachExecutionEventFactory(filter, AgentExecutionNode.factory(null, args[1]));
                        obj.data.registerHandle(type, handle, args[1]);
                        break block4;
                    }
                    case CLOSE: {
                        obj.data.registerOnClose(args[1]);
                        break block4;
                    }
                }
                throw new IllegalStateException();
            }
            case "off": {
                CompilerDirectives.transferToInterpreter();
                AgentType type = AgentType.find(AgentObject.convertToString(interop, args[0]));
                obj.data.removeHandle(type, args[1]);
                break;
            }
            default: {
                throw UnknownIdentifierException.create((String)member);
            }
        }
        return obj;
    }

    private void warnMsg() {
        byte[] arr = this.msg;
        if (arr != null) {
            try {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.env.err().write(arr);
                this.msg = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String convertToString(InteropLibrary interop, Object obj) throws UnsupportedMessageException {
        return interop.asString(obj);
    }

    private static SourceSectionFilter createFilter(AgentObject obj, Object[] args) throws IllegalArgumentException, UnsupportedMessageException {
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder().sourceIs((SourceSectionFilter.SourcePredicate)obj.excludeSources).includeInternal(false);
        ArrayList<Class<StandardTags.RootBodyTag>> allTags = new ArrayList<Class<StandardTags.RootBodyTag>>();
        if (args.length > 2) {
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            Object config = args[2];
            Object allMembers = iop.getMembers(config, false);
            long allMembersSize = iop.getArraySize(allMembers);
            int i = 0;
            while ((long)i < allMembersSize) {
                block26: {
                    String type;
                    Object atI;
                    try {
                        atI = iop.readArrayElement(allMembers, (long)i);
                    }
                    catch (InvalidArrayIndexException ex) {
                        break block26;
                    }
                    switch (type = iop.asString(atI)) {
                        case "expressions": {
                            if (!AgentObject.isSet(iop, config, "expressions")) break;
                            allTags.add(StandardTags.ExpressionTag.class);
                            break;
                        }
                        case "statements": {
                            if (!AgentObject.isSet(iop, config, "statements")) break;
                            allTags.add(StandardTags.StatementTag.class);
                            break;
                        }
                        case "roots": {
                            if (!AgentObject.isSet(iop, config, "roots")) break;
                            allTags.add(StandardTags.RootBodyTag.class);
                            break;
                        }
                        case "rootNameFilter": {
                            Object fn2;
                            try {
                                fn2 = iop.readMember(config, "rootNameFilter");
                                if (fn2 == null || iop.isNull(fn2)) break;
                                if (iop.isString(fn2)) {
                                    builder.rootNameIs((Predicate)new RegexNameFilter(iop.asString(fn2)));
                                    break;
                                }
                                if (!iop.isExecutable(fn2)) {
                                    throw new IllegalArgumentException("rootNameFilter should be a string, a regular expression!");
                                }
                                builder.rootNameIs((Predicate)new RootNameFilter(fn2));
                            }
                            catch (UnknownIdentifierException fn2) {}
                            break;
                        }
                        case "sourceFilter": {
                            Object fn2;
                            try {
                                fn2 = iop.readMember(config, "sourceFilter");
                                if (fn2 == null || iop.isNull(fn2)) break;
                                if (!iop.isExecutable(fn2)) {
                                    throw new IllegalArgumentException("sourceFilter has to be a function!");
                                }
                                SourceFilter filter = SourceFilter.newBuilder().sourceIs((Predicate)new AgentSourceFilter(fn2)).build();
                                builder.sourceFilter(filter);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {}
                            break;
                        }
                        default: {
                            throw InsightException.unknownAttribute(type);
                        }
                    }
                }
                ++i;
            }
        }
        if (allTags.isEmpty()) {
            throw new IllegalArgumentException("No elements specified to listen to for execution listener. Need to specify at least one element kind: expressions, statements or roots.");
        }
        builder.tagIs(allTags.toArray(new Class[0]));
        SourceSectionFilter filter = builder.build();
        return filter;
    }

    @ExportMessage
    static boolean isMemberInvocable(AgentObject obj, String member) {
        return false;
    }

    private static boolean isSet(InteropLibrary iop, Object obj, String property) {
        try {
            Object value = iop.readMember(obj, property);
            return Boolean.TRUE.equals(value);
        }
        catch (UnknownIdentifierException ex) {
            return false;
        }
        catch (InteropException ex) {
            throw InsightException.raise((Exception)((Object)ex));
        }
    }

    @CompilerDirectives.TruffleBoundary
    void onClosed() {
        this.data.onClosed();
    }

    static class Data {
        final Map<AgentType, Map<Object, EventBinding<?>>> listeners = new EnumMap(AgentType.class);
        Object closeFn;

        Data() {
        }

        synchronized void registerHandle(AgentType at, EventBinding<?> handle, Object arg) {
            Map<Object, EventBinding<?>> listenersForType = this.listeners.get((Object)at);
            if (listenersForType == null) {
                listenersForType = new LinkedHashMap();
                this.listeners.put(at, listenersForType);
            }
            listenersForType.put(arg, handle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeHandle(AgentType type, Object arg) {
            EventBinding<?> remove;
            Data data = this;
            synchronized (data) {
                Map<Object, EventBinding<?>> listenersForType = this.listeners.get((Object)type);
                remove = listenersForType == null ? null : listenersForType.get(arg);
            }
            if (remove != null) {
                remove.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        void onClosed() {
            Data data = this;
            synchronized (data) {
                for (Map.Entry<AgentType, Map<Object, EventBinding<?>>> entry : this.listeners.entrySet()) {
                    Map<Object, EventBinding<?>> val = entry.getValue();
                    for (EventBinding<?> binding : val.values()) {
                        binding.dispose();
                    }
                }
            }
            if (this.closeFn == null) {
                return;
            }
            InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            try {
                iop.execute(this.closeFn, new Object[0]);
            }
            catch (InteropException ex) {
                throw InsightException.raise((Exception)((Object)ex));
            }
            finally {
                this.closeFn = null;
            }
        }

        void registerOnClose(Object fn) {
            this.closeFn = fn;
        }
    }
}

