// CheckStyle: start generated
package com.oracle.truffle.tools.agentscript;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.tools.agentscript.FrameLibrary.Query;
import com.oracle.truffle.tools.agentscript.impl.DefaultFrameLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;

@GeneratedBy(FrameLibrary.class)
final class FrameLibraryGen extends LibraryFactory<FrameLibrary> {

    private static final Class<FrameLibrary> LIBRARY_CLASS = FrameLibraryGen.lazyLibraryClass();
    private static final Message READ_MEMBER = new MessageImpl("readMember", 0, Object.class, Query.class, String.class);
    private static final Message WRITE_MEMBER = new MessageImpl("writeMember", 1, void.class, Query.class, String.class, Object.class);
    private static final Message COLLECT_NAMES = new MessageImpl("collectNames", 2, void.class, Query.class, Set.class);
    private static final FrameLibraryGen INSTANCE = new FrameLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(FrameLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(FrameLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private FrameLibraryGen() {
        super(FrameLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(FrameLibraryGen.READ_MEMBER, FrameLibraryGen.WRITE_MEMBER, FrameLibraryGen.COLLECT_NAMES)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Query) {
            return DefaultFrameLibrary.class;
        } else {
            return FrameLibrary.class;
        }
    }

    @Override
    protected FrameLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl) message).index);
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected FrameLibrary createDelegate(FrameLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        FrameLibrary lib = (FrameLibrary) originalLib;
        MessageImpl messageImpl = (MessageImpl) message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0 :
                return lib.readMember((Query) receiver, (String) args[offset]);
            case 1 :
                lib.writeMember((Query) receiver, (String) args[offset], args[offset + 1]);
                return null;
            case 2 :
                lib.collectNames((Query) receiver, (Set<String>) args[offset]);
                return null;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected FrameLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected FrameLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<FrameLibrary> lazyLibraryClass() {
        try {
            return (Class<FrameLibrary>) Class.forName("com.oracle.truffle.tools.agentscript.FrameLibrary", false, FrameLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(FrameLibrary.class)
    private static final class Default extends LibraryExport<FrameLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private Default() {
            super(FrameLibrary.class, Query.class, false);
        }

        @Override
        protected FrameLibrary createUncached(Object receiver) {
            assert receiver instanceof Query;
            FrameLibrary uncached = Default.UNCACHED;
            return uncached;
        }

        @Override
        protected FrameLibrary createCached(Object receiver) {
            assert receiver instanceof Query;
            return Default.CACHE;
        }

        @GeneratedBy(FrameLibrary.class)
        private static final class Cached extends FrameLibrary {

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Query) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Query;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public Object readMember(Query receiver, String member) throws UnknownIdentifierException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readMember(((receiver)), member);
            }

            @Override
            public void writeMember(Query receiver, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeMember(((receiver)), member, value);
                return;
            }

            @Override
            public void collectNames(Query receiver, Set<String> names) throws InteropException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.collectNames(((receiver)), names);
                return;
            }

        }
        @GeneratedBy(FrameLibrary.class)
        private static final class Uncached extends FrameLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Query) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Query;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object readMember(Query receiver, String member) throws UnknownIdentifierException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.readMember(receiver, member);
            }

            @TruffleBoundary
            @Override
            public void writeMember(Query receiver, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.writeMember(receiver, member, value);
                return;
            }

            @TruffleBoundary
            @Override
            public void collectNames(Query receiver, Set<String> names) throws InteropException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.collectNames(receiver, names);
                return;
            }

        }
    }
    @GeneratedBy(FrameLibrary.class)
    private static class MessageImpl extends Message {

        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?>... parameters) {
            super(FrameLibraryGen.LIBRARY_CLASS, name, returnType, parameters);
            this.index = index;
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private static final class Proxy extends FrameLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object readMember(Query receiver_, String member) throws UnknownIdentifierException {
            try {
                return lib.send(receiver_, FrameLibraryGen.READ_MEMBER, member);
            } catch (UnknownIdentifierException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void writeMember(Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            try {
                lib.send(receiver_, FrameLibraryGen.WRITE_MEMBER, member, value);
                return;
            } catch (UnknownIdentifierException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void collectNames(Query receiver_, Set<String> names) throws InteropException {
            try {
                lib.send(receiver_, FrameLibraryGen.COLLECT_NAMES, names);
                return;
            } catch (InteropException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private static final class Delegate extends FrameLibrary {

        @Child private FrameLibrary delegateLibrary;

        Delegate(FrameLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object readMember(Query receiver_, String member) throws UnknownIdentifierException {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).readMember((Query) delegate, member);
            } else {
                return this.delegateLibrary.readMember(receiver_, member);
            }
        }

        @Override
        public void writeMember(Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).writeMember((Query) delegate, member, value);
                return;
            } else {
                this.delegateLibrary.writeMember(receiver_, member, value);
                return;
            }
        }

        @Override
        public void collectNames(Query receiver_, Set<String> names) throws InteropException {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).collectNames((Query) delegate, names);
                return;
            } else {
                this.delegateLibrary.collectNames(receiver_, names);
                return;
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private static final class CachedToUncachedDispatch extends FrameLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public Object readMember(Query receiver_, String member) throws UnknownIdentifierException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).readMember(receiver_, member);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void writeMember(Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).writeMember(receiver_, member, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void collectNames(Query receiver_, Set<String> names) throws InteropException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).collectNames(receiver_, names);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private static final class UncachedDispatch extends FrameLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public Object readMember(Query receiver_, String member) throws UnknownIdentifierException {
            return INSTANCE.getUncached(receiver_).readMember(receiver_, member);
        }

        @TruffleBoundary
        @Override
        public void writeMember(Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).writeMember(receiver_, member, value);
            return;
        }

        @TruffleBoundary
        @Override
        public void collectNames(Query receiver_, Set<String> names) throws InteropException {
            INSTANCE.getUncached(receiver_).collectNames(receiver_, names);
            return;
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(FrameLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(FrameLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(FrameLibrary.class)
    private abstract static class CachedDispatch extends FrameLibrary {

        @Child FrameLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(FrameLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public Object readMember(Query receiver_, String member) throws UnknownIdentifierException {
            do {
                CachedDispatch current = this;
                do {
                    FrameLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.readMember(receiver_, member);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void writeMember(Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    FrameLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.writeMember(receiver_, member, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void collectNames(Query receiver_, Set<String> names) throws InteropException {
            do {
                CachedDispatch current = this;
                do {
                    FrameLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.collectNames(receiver_, names);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Query receiver_) {
            CachedDispatch current = this;
            FrameLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = insert(INSTANCE.create(receiver_));
            } else {
                Lock lock = getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        FrameLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                } finally {
                    lock.unlock();
                }
            }
        }

    }
}
