/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class StepInArguments
extends JSONBase {
    StepInArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public int getThreadId() {
        return this.jsonData.getInt("threadId");
    }

    public StepInArguments setThreadId(int threadId) {
        this.jsonData.put("threadId", threadId);
        return this;
    }

    public Integer getTargetId() {
        return this.jsonData.has("targetId") ? Integer.valueOf(this.jsonData.getInt("targetId")) : null;
    }

    public StepInArguments setTargetId(Integer targetId) {
        this.jsonData.putOpt("targetId", targetId);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StepInArguments other = (StepInArguments)obj;
        if (this.getThreadId() != other.getThreadId()) {
            return false;
        }
        return Objects.equals(this.getTargetId(), other.getTargetId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Integer.hashCode(this.getThreadId());
        if (this.getTargetId() != null) {
            hash = 29 * hash + Integer.hashCode(this.getTargetId());
        }
        return hash;
    }

    public static StepInArguments create(Integer threadId) {
        JSONObject json = new JSONObject();
        json.put("threadId", threadId);
        return new StepInArguments(json);
    }
}

