/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.AttachRequestArguments;
import com.oracle.truffle.tools.dap.types.AttachResponse;
import com.oracle.truffle.tools.dap.types.BreakpointEvent;
import com.oracle.truffle.tools.dap.types.BreakpointLocationsArguments;
import com.oracle.truffle.tools.dap.types.BreakpointLocationsResponse;
import com.oracle.truffle.tools.dap.types.CancelArguments;
import com.oracle.truffle.tools.dap.types.CancelResponse;
import com.oracle.truffle.tools.dap.types.Capabilities;
import com.oracle.truffle.tools.dap.types.CapabilitiesEvent;
import com.oracle.truffle.tools.dap.types.CompletionsArguments;
import com.oracle.truffle.tools.dap.types.CompletionsResponse;
import com.oracle.truffle.tools.dap.types.ConfigurationDoneArguments;
import com.oracle.truffle.tools.dap.types.ConfigurationDoneResponse;
import com.oracle.truffle.tools.dap.types.ContinueArguments;
import com.oracle.truffle.tools.dap.types.ContinueResponse;
import com.oracle.truffle.tools.dap.types.ContinuedEvent;
import com.oracle.truffle.tools.dap.types.DataBreakpointInfoArguments;
import com.oracle.truffle.tools.dap.types.DataBreakpointInfoResponse;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import com.oracle.truffle.tools.dap.types.DisassembleArguments;
import com.oracle.truffle.tools.dap.types.DisassembleResponse;
import com.oracle.truffle.tools.dap.types.DisconnectArguments;
import com.oracle.truffle.tools.dap.types.DisconnectResponse;
import com.oracle.truffle.tools.dap.types.ErrorResponse;
import com.oracle.truffle.tools.dap.types.EvaluateArguments;
import com.oracle.truffle.tools.dap.types.EvaluateResponse;
import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.ExceptionInfoArguments;
import com.oracle.truffle.tools.dap.types.ExceptionInfoResponse;
import com.oracle.truffle.tools.dap.types.ExitedEvent;
import com.oracle.truffle.tools.dap.types.GotoArguments;
import com.oracle.truffle.tools.dap.types.GotoResponse;
import com.oracle.truffle.tools.dap.types.GotoTargetsArguments;
import com.oracle.truffle.tools.dap.types.GotoTargetsResponse;
import com.oracle.truffle.tools.dap.types.InitializeRequestArguments;
import com.oracle.truffle.tools.dap.types.InitializeResponse;
import com.oracle.truffle.tools.dap.types.InitializedEvent;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.LaunchRequestArguments;
import com.oracle.truffle.tools.dap.types.LaunchResponse;
import com.oracle.truffle.tools.dap.types.LoadedSourceEvent;
import com.oracle.truffle.tools.dap.types.LoadedSourcesArguments;
import com.oracle.truffle.tools.dap.types.LoadedSourcesResponse;
import com.oracle.truffle.tools.dap.types.Message;
import com.oracle.truffle.tools.dap.types.ModuleEvent;
import com.oracle.truffle.tools.dap.types.ModulesArguments;
import com.oracle.truffle.tools.dap.types.ModulesResponse;
import com.oracle.truffle.tools.dap.types.NextArguments;
import com.oracle.truffle.tools.dap.types.NextResponse;
import com.oracle.truffle.tools.dap.types.OutputEvent;
import com.oracle.truffle.tools.dap.types.PauseArguments;
import com.oracle.truffle.tools.dap.types.PauseResponse;
import com.oracle.truffle.tools.dap.types.ProcessEvent;
import com.oracle.truffle.tools.dap.types.ProgressEndEvent;
import com.oracle.truffle.tools.dap.types.ProgressStartEvent;
import com.oracle.truffle.tools.dap.types.ProgressUpdateEvent;
import com.oracle.truffle.tools.dap.types.ProtocolMessage;
import com.oracle.truffle.tools.dap.types.ReadMemoryArguments;
import com.oracle.truffle.tools.dap.types.ReadMemoryResponse;
import com.oracle.truffle.tools.dap.types.Request;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.RestartArguments;
import com.oracle.truffle.tools.dap.types.RestartFrameArguments;
import com.oracle.truffle.tools.dap.types.RestartFrameResponse;
import com.oracle.truffle.tools.dap.types.RestartResponse;
import com.oracle.truffle.tools.dap.types.ReverseContinueArguments;
import com.oracle.truffle.tools.dap.types.ReverseContinueResponse;
import com.oracle.truffle.tools.dap.types.RunInTerminalRequestArguments;
import com.oracle.truffle.tools.dap.types.RunInTerminalResponse;
import com.oracle.truffle.tools.dap.types.ScopesArguments;
import com.oracle.truffle.tools.dap.types.ScopesResponse;
import com.oracle.truffle.tools.dap.types.SetBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetBreakpointsResponse;
import com.oracle.truffle.tools.dap.types.SetDataBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetDataBreakpointsResponse;
import com.oracle.truffle.tools.dap.types.SetExceptionBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetExceptionBreakpointsResponse;
import com.oracle.truffle.tools.dap.types.SetExpressionArguments;
import com.oracle.truffle.tools.dap.types.SetExpressionResponse;
import com.oracle.truffle.tools.dap.types.SetFunctionBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetFunctionBreakpointsResponse;
import com.oracle.truffle.tools.dap.types.SetVariableArguments;
import com.oracle.truffle.tools.dap.types.SetVariableResponse;
import com.oracle.truffle.tools.dap.types.SourceArguments;
import com.oracle.truffle.tools.dap.types.SourceResponse;
import com.oracle.truffle.tools.dap.types.StackTraceArguments;
import com.oracle.truffle.tools.dap.types.StackTraceResponse;
import com.oracle.truffle.tools.dap.types.StepBackArguments;
import com.oracle.truffle.tools.dap.types.StepBackResponse;
import com.oracle.truffle.tools.dap.types.StepInArguments;
import com.oracle.truffle.tools.dap.types.StepInResponse;
import com.oracle.truffle.tools.dap.types.StepInTargetsArguments;
import com.oracle.truffle.tools.dap.types.StepInTargetsResponse;
import com.oracle.truffle.tools.dap.types.StepOutArguments;
import com.oracle.truffle.tools.dap.types.StepOutResponse;
import com.oracle.truffle.tools.dap.types.StoppedEvent;
import com.oracle.truffle.tools.dap.types.TerminateArguments;
import com.oracle.truffle.tools.dap.types.TerminateResponse;
import com.oracle.truffle.tools.dap.types.TerminateThreadsArguments;
import com.oracle.truffle.tools.dap.types.TerminateThreadsResponse;
import com.oracle.truffle.tools.dap.types.TerminatedEvent;
import com.oracle.truffle.tools.dap.types.ThreadEvent;
import com.oracle.truffle.tools.dap.types.ThreadsResponse;
import com.oracle.truffle.tools.dap.types.VariablesArguments;
import com.oracle.truffle.tools.dap.types.VariablesResponse;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugProtocolServer {
    public CompletableFuture<Void> cancel(CancelArguments args) {
        throw new UnsupportedOperationException("'cancel' command not supported");
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        throw new UnsupportedOperationException("'initialize' command not supported");
    }

    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        throw new UnsupportedOperationException("'configurationDone' command not supported");
    }

    public CompletableFuture<Void> launch(LaunchRequestArguments args) {
        throw new UnsupportedOperationException("'launch' command not supported");
    }

    public CompletableFuture<Void> attach(AttachRequestArguments args) {
        throw new UnsupportedOperationException("'attach' command not supported");
    }

    public CompletableFuture<Void> restart(RestartArguments args) {
        throw new UnsupportedOperationException("'restart' command not supported");
    }

    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        throw new UnsupportedOperationException("'disconnect' command not supported");
    }

    public CompletableFuture<Void> terminate(TerminateArguments args) {
        throw new UnsupportedOperationException("'terminate' command not supported");
    }

    public CompletableFuture<BreakpointLocationsResponse.ResponseBody> breakpointLocations(BreakpointLocationsArguments args) {
        throw new UnsupportedOperationException("'breakpointLocations' command not supported");
    }

    public CompletableFuture<SetBreakpointsResponse.ResponseBody> setBreakpoints(SetBreakpointsArguments args) {
        throw new UnsupportedOperationException("'setBreakpoints' command not supported");
    }

    public CompletableFuture<SetFunctionBreakpointsResponse.ResponseBody> setFunctionBreakpoints(SetFunctionBreakpointsArguments args) {
        throw new UnsupportedOperationException("'setFunctionBreakpoints' command not supported");
    }

    public CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        throw new UnsupportedOperationException("'setExceptionBreakpoints' command not supported");
    }

    public CompletableFuture<DataBreakpointInfoResponse.ResponseBody> dataBreakpointInfo(DataBreakpointInfoArguments args) {
        throw new UnsupportedOperationException("'dataBreakpointInfo' command not supported");
    }

    public CompletableFuture<SetDataBreakpointsResponse.ResponseBody> setDataBreakpoints(SetDataBreakpointsArguments args) {
        throw new UnsupportedOperationException("'setDataBreakpoints' command not supported");
    }

    public CompletableFuture<ContinueResponse.ResponseBody> doContinue(ContinueArguments args) {
        throw new UnsupportedOperationException("'doContinue' command not supported");
    }

    public CompletableFuture<Void> next(NextArguments args) {
        throw new UnsupportedOperationException("'next' command not supported");
    }

    public CompletableFuture<Void> stepIn(StepInArguments args) {
        throw new UnsupportedOperationException("'stepIn' command not supported");
    }

    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        throw new UnsupportedOperationException("'stepOut' command not supported");
    }

    public CompletableFuture<Void> stepBack(StepBackArguments args) {
        throw new UnsupportedOperationException("'stepBack' command not supported");
    }

    public CompletableFuture<Void> reverseContinue(ReverseContinueArguments args) {
        throw new UnsupportedOperationException("'reverseContinue' command not supported");
    }

    public CompletableFuture<Void> restartFrame(RestartFrameArguments args) {
        throw new UnsupportedOperationException("'restartFrame' command not supported");
    }

    public CompletableFuture<Void> doGoto(GotoArguments args) {
        throw new UnsupportedOperationException("'doGoto' command not supported");
    }

    public CompletableFuture<Void> pause(PauseArguments args) {
        throw new UnsupportedOperationException("'pause' command not supported");
    }

    public CompletableFuture<StackTraceResponse.ResponseBody> stackTrace(StackTraceArguments args) {
        throw new UnsupportedOperationException("'stackTrace' command not supported");
    }

    public CompletableFuture<ScopesResponse.ResponseBody> scopes(ScopesArguments args) {
        throw new UnsupportedOperationException("'scopes' command not supported");
    }

    public CompletableFuture<VariablesResponse.ResponseBody> variables(VariablesArguments args) {
        throw new UnsupportedOperationException("'variables' command not supported");
    }

    public CompletableFuture<SetVariableResponse.ResponseBody> setVariable(SetVariableArguments args) {
        throw new UnsupportedOperationException("'setVariable' command not supported");
    }

    public CompletableFuture<SourceResponse.ResponseBody> source(SourceArguments args) {
        throw new UnsupportedOperationException("'source' command not supported");
    }

    public CompletableFuture<ThreadsResponse.ResponseBody> threads() {
        throw new UnsupportedOperationException("'threads' command not supported");
    }

    public CompletableFuture<Void> terminateThreads(TerminateThreadsArguments args) {
        throw new UnsupportedOperationException("'terminateThreads' command not supported");
    }

    public CompletableFuture<ModulesResponse.ResponseBody> modules(ModulesArguments args) {
        throw new UnsupportedOperationException("'modules' command not supported");
    }

    public CompletableFuture<LoadedSourcesResponse.ResponseBody> loadedSources(LoadedSourcesArguments args) {
        throw new UnsupportedOperationException("'loadedSources' command not supported");
    }

    public CompletableFuture<EvaluateResponse.ResponseBody> evaluate(EvaluateArguments args) {
        throw new UnsupportedOperationException("'evaluate' command not supported");
    }

    public CompletableFuture<SetExpressionResponse.ResponseBody> setExpression(SetExpressionArguments args) {
        throw new UnsupportedOperationException("'setExpression' command not supported");
    }

    public CompletableFuture<StepInTargetsResponse.ResponseBody> stepInTargets(StepInTargetsArguments args) {
        throw new UnsupportedOperationException("'stepInTargets' command not supported");
    }

    public CompletableFuture<GotoTargetsResponse.ResponseBody> gotoTargets(GotoTargetsArguments args) {
        throw new UnsupportedOperationException("'gotoTargets' command not supported");
    }

    public CompletableFuture<CompletionsResponse.ResponseBody> completions(CompletionsArguments args) {
        throw new UnsupportedOperationException("'completions' command not supported");
    }

    public CompletableFuture<ExceptionInfoResponse.ResponseBody> exceptionInfo(ExceptionInfoArguments args) {
        throw new UnsupportedOperationException("'exceptionInfo' command not supported");
    }

    public CompletableFuture<ReadMemoryResponse.ResponseBody> readMemory(ReadMemoryArguments args) {
        throw new UnsupportedOperationException("'readMemory' command not supported");
    }

    public CompletableFuture<DisassembleResponse.ResponseBody> disassemble(DisassembleArguments args) {
        throw new UnsupportedOperationException("'disassemble' command not supported");
    }

    protected void connect(DebugProtocolClient client) {
    }

    public LoggerProxy getLogger() {
        final Logger l = Logger.getLogger(DebugProtocolServer.class.getName());
        return new LoggerProxy(){

            @Override
            public boolean isLoggable(Level level) {
                return l.isLoggable(level);
            }

            @Override
            public void log(Level level, String msg) {
                l.log(level, msg);
            }

            @Override
            public void log(Level level, String msg, Throwable thrown) {
                l.log(level, msg, thrown);
            }
        };
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static interface LoggerProxy {
        public boolean isLoggable(Level var1);

        public void log(Level var1, String var2);

        public void log(Level var1, String var2, Throwable var3);
    }

    public static class ExceptionWithMessage
    extends RuntimeException {
        private static final long serialVersionUID = 4950848492025420535L;
        private final Message debugMessage;

        public ExceptionWithMessage(Message debugMessage, String message) {
            super(message);
            this.debugMessage = debugMessage;
        }

        public Message getDebugMessage() {
            return this.debugMessage;
        }
    }

    public static final class Session
    implements Runnable {
        private static final String CONTENT_LENGTH_HEADER = "Content-Length:";
        private final DebugProtocolServer server;
        private final InputStream in;
        private final OutputStream out;
        private final Map<Integer, CompletableFuture<Response>> pendingSentRequests = new ConcurrentHashMap<Integer, CompletableFuture<Response>>();
        private final Map<Integer, CompletableFuture<?>> pendingReceivedRequests = new ConcurrentHashMap();
        private AtomicInteger sequenceNum = new AtomicInteger(1);
        private boolean closed = false;

        private Session(DebugProtocolServer server, InputStream in, OutputStream out) {
            this.server = server;
            this.in = in;
            this.out = out;
            this.server.connect(new DebugProtocolClient(){

                @Override
                public void initialized() {
                    this.sendEvent(InitializedEvent.create(sequenceNum.getAndIncrement()));
                }

                @Override
                public void stopped(StoppedEvent.EventBody body) {
                    this.sendEvent(StoppedEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void continued(ContinuedEvent.EventBody body) {
                    this.sendEvent(ContinuedEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void exited(ExitedEvent.EventBody body) {
                    this.sendEvent(ExitedEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void terminated(TerminatedEvent.EventBody body) {
                    this.sendEvent(TerminatedEvent.create(sequenceNum.getAndIncrement()).setBody(body));
                }

                @Override
                public void thread(ThreadEvent.EventBody body) {
                    this.sendEvent(ThreadEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void output(OutputEvent.EventBody body) {
                    this.sendEvent(OutputEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void breakpoint(BreakpointEvent.EventBody body) {
                    this.sendEvent(BreakpointEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void module(ModuleEvent.EventBody body) {
                    this.sendEvent(ModuleEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void loadedSource(LoadedSourceEvent.EventBody body) {
                    this.sendEvent(LoadedSourceEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void process(ProcessEvent.EventBody body) {
                    this.sendEvent(ProcessEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void capabilities(CapabilitiesEvent.EventBody body) {
                    this.sendEvent(CapabilitiesEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void progressStart(ProgressStartEvent.EventBody body) {
                    this.sendEvent(ProgressStartEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void progressUpdate(ProgressUpdateEvent.EventBody body) {
                    this.sendEvent(ProgressUpdateEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public void progressEnd(ProgressEndEvent.EventBody body) {
                    this.sendEvent(ProgressEndEvent.create(body, (Integer)sequenceNum.getAndIncrement()));
                }

                @Override
                public CompletableFuture<RunInTerminalResponse> runInTerminal(RunInTerminalRequestArguments args) {
                    return this.sendRequest(Request.create("runInTerminal", sequenceNum.getAndIncrement()).setArguments(Session.getJSONData(args))).thenApply(response -> (RunInTerminalResponse)response);
                }
            });
        }

        @Override
        public void run() {
            try {
                while (!this.closed) {
                    byte[] messageBytes = Session.readMessageBytes(this.in, this.server.getLogger());
                    if (messageBytes == null) {
                        this.closed = true;
                        continue;
                    }
                    this.processMessage(messageBytes);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static byte[] readMessageBytes(InputStream in, LoggerProxy logger) throws IOException {
            StringBuilder line = new StringBuilder();
            int contentLength = -1;
            int c;
            while ((c = in.read()) != -1) {
                if (c == 10) {
                    String header = line.toString().trim();
                    if (header.length() > 0) {
                        if (header.startsWith(CONTENT_LENGTH_HEADER)) {
                            try {
                                contentLength = Integer.parseInt(header.substring(CONTENT_LENGTH_HEADER.length()).trim());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if (contentLength < 0) {
                        logger.log(Level.SEVERE, "Error while processing an incomming message: Missing header Content-Length: in input.");
                    } else {
                        int read;
                        byte[] buffer = new byte[contentLength];
                        for (int bytesRead = 0; bytesRead < contentLength; bytesRead += read) {
                            read = in.read(buffer, bytesRead, contentLength - bytesRead);
                            if (read != -1) continue;
                            return null;
                        }
                        return buffer;
                    }
                    line = new StringBuilder();
                    continue;
                }
                if (c == 13) continue;
                line.append((char)c);
            }
            return null;
        }

        private void processMessage(byte[] messageBytes) {
            try {
                String messageType;
                String content = new String(messageBytes, StandardCharsets.UTF_8);
                ProtocolMessage message = new ProtocolMessage(new JSONObject(content));
                switch (messageType = message.getType()) {
                    case "request": {
                        Request request = new Request(message.jsonData);
                        if (this.server.getLogger().isLoggable(Level.FINER)) {
                            String format = "[Trace - %s] Received request '%s - (%d)'\nArgs: %s";
                            this.server.getLogger().log(Level.FINER, DebugProtocolServer.format(format, Instant.now().toString(), request.getCommand(), request.getSeq(), Session.getJSONData(request.getArguments())));
                        }
                        this.processRequest(request);
                        break;
                    }
                    case "response": {
                        Response response = new Response(message.jsonData);
                        if (this.server.getLogger().isLoggable(Level.FINER)) {
                            String format = "[Trace - %s] Received response '(%d)'\nResult: %s";
                            this.server.getLogger().log(Level.FINER, DebugProtocolServer.format(format, Instant.now().toString(), response.getRequestSeq(), Session.getJSONData(response.getBody())));
                        }
                        this.processResponse(response);
                        break;
                    }
                    default: {
                        this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create().setError(Message.create(1014, "Unrecognized message type: {_type}").setVariables(Collections.singletonMap("_type", messageType))), message.getSeq(), false, null, this.sequenceNum.getAndIncrement()).setMessage(DebugProtocolServer.format("Unrecognized message type: `%s`", messageType)));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.server.getLogger().log(Level.SEVERE, "Error while processing an incomming message: " + e.getMessage());
            }
        }

        private void processRequest(Request request) {
            int seq = request.getSeq();
            String command = request.getCommand();
            try {
                JSONObject args = request.getArguments() instanceof JSONObject ? (JSONObject)request.getArguments() : null;
                CompletionStage future = null;
                switch (command) {
                    case "cancel": {
                        future = this.server.cancel(new CancelArguments(args)).thenAccept(body -> this.sendResponse(CancelResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "initialize": {
                        future = this.server.initialize(new InitializeRequestArguments(args)).thenAccept(body -> this.sendResponse(InitializeResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody((Capabilities)body)));
                        break;
                    }
                    case "configurationDone": {
                        future = this.server.configurationDone(new ConfigurationDoneArguments(args)).thenAccept(body -> this.sendResponse(ConfigurationDoneResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "launch": {
                        future = this.server.launch(new LaunchRequestArguments(args)).thenAccept(body -> this.sendResponse(LaunchResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "attach": {
                        future = this.server.attach(new AttachRequestArguments(args)).thenAccept(body -> this.sendResponse(AttachResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "restart": {
                        future = this.server.restart(new RestartArguments(args)).thenAccept(body -> this.sendResponse(RestartResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "disconnect": {
                        future = this.server.disconnect(new DisconnectArguments(args)).thenAccept(body -> this.sendResponse(DisconnectResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "terminate": {
                        future = this.server.terminate(new TerminateArguments(args)).thenAccept(body -> this.sendResponse(TerminateResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "breakpointLocations": {
                        future = this.server.breakpointLocations(new BreakpointLocationsArguments(args)).thenAccept(body -> this.sendResponse(BreakpointLocationsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "setBreakpoints": {
                        future = this.server.setBreakpoints(new SetBreakpointsArguments(args)).thenAccept(body -> this.sendResponse(SetBreakpointsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "setFunctionBreakpoints": {
                        future = this.server.setFunctionBreakpoints(new SetFunctionBreakpointsArguments(args)).thenAccept(body -> this.sendResponse(SetFunctionBreakpointsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "setExceptionBreakpoints": {
                        future = this.server.setExceptionBreakpoints(new SetExceptionBreakpointsArguments(args)).thenAccept(body -> this.sendResponse(SetExceptionBreakpointsResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "dataBreakpointInfo": {
                        future = this.server.dataBreakpointInfo(new DataBreakpointInfoArguments(args)).thenAccept(body -> this.sendResponse(DataBreakpointInfoResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "setDataBreakpoints": {
                        future = this.server.setDataBreakpoints(new SetDataBreakpointsArguments(args)).thenAccept(body -> this.sendResponse(SetDataBreakpointsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "continue": {
                        future = this.server.doContinue(new ContinueArguments(args)).thenAccept(body -> this.sendResponse(ContinueResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "next": {
                        future = this.server.next(new NextArguments(args)).thenAccept(body -> this.sendResponse(NextResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "stepIn": {
                        future = this.server.stepIn(new StepInArguments(args)).thenAccept(body -> this.sendResponse(StepInResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "stepOut": {
                        future = this.server.stepOut(new StepOutArguments(args)).thenAccept(body -> this.sendResponse(StepOutResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "stepBack": {
                        future = this.server.stepBack(new StepBackArguments(args)).thenAccept(body -> this.sendResponse(StepBackResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "reverseContinue": {
                        future = this.server.reverseContinue(new ReverseContinueArguments(args)).thenAccept(body -> this.sendResponse(ReverseContinueResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "restartFrame": {
                        future = this.server.restartFrame(new RestartFrameArguments(args)).thenAccept(body -> this.sendResponse(RestartFrameResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "goto": {
                        future = this.server.doGoto(new GotoArguments(args)).thenAccept(body -> this.sendResponse(GotoResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "pause": {
                        future = this.server.pause(new PauseArguments(args)).thenAccept(body -> this.sendResponse(PauseResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "stackTrace": {
                        future = this.server.stackTrace(new StackTraceArguments(args)).thenAccept(body -> this.sendResponse(StackTraceResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "scopes": {
                        future = this.server.scopes(new ScopesArguments(args)).thenAccept(body -> this.sendResponse(ScopesResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "variables": {
                        future = this.server.variables(new VariablesArguments(args)).thenAccept(body -> this.sendResponse(VariablesResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "setVariable": {
                        future = this.server.setVariable(new SetVariableArguments(args)).thenAccept(body -> this.sendResponse(SetVariableResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "source": {
                        future = this.server.source(new SourceArguments(args)).thenAccept(body -> this.sendResponse(SourceResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "threads": {
                        future = this.server.threads().thenAccept(body -> this.sendResponse(ThreadsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "terminateThreads": {
                        future = this.server.terminateThreads(new TerminateThreadsArguments(args)).thenAccept(body -> this.sendResponse(TerminateThreadsResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody(body)));
                        break;
                    }
                    case "modules": {
                        future = this.server.modules(new ModulesArguments(args)).thenAccept(body -> this.sendResponse(ModulesResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "loadedSources": {
                        future = this.server.loadedSources(new LoadedSourcesArguments(args)).thenAccept(body -> this.sendResponse(LoadedSourcesResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "evaluate": {
                        future = this.server.evaluate(new EvaluateArguments(args)).thenAccept(body -> this.sendResponse(EvaluateResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "setExpression": {
                        future = this.server.setExpression(new SetExpressionArguments(args)).thenAccept(body -> this.sendResponse(SetExpressionResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "stepInTargets": {
                        future = this.server.stepInTargets(new StepInTargetsArguments(args)).thenAccept(body -> this.sendResponse(StepInTargetsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "gotoTargets": {
                        future = this.server.gotoTargets(new GotoTargetsArguments(args)).thenAccept(body -> this.sendResponse(GotoTargetsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "completions": {
                        future = this.server.completions(new CompletionsArguments(args)).thenAccept(body -> this.sendResponse(CompletionsResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "exceptionInfo": {
                        future = this.server.exceptionInfo(new ExceptionInfoArguments(args)).thenAccept(body -> this.sendResponse(ExceptionInfoResponse.create(body, seq, true, command, this.sequenceNum.getAndIncrement())));
                        break;
                    }
                    case "readMemory": {
                        future = this.server.readMemory(new ReadMemoryArguments(args)).thenAccept(body -> this.sendResponse(ReadMemoryResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody((ReadMemoryResponse.ResponseBody)body)));
                        break;
                    }
                    case "disassemble": {
                        future = this.server.disassemble(new DisassembleArguments(args)).thenAccept(body -> this.sendResponse(DisassembleResponse.create(seq, true, command, this.sequenceNum.getAndIncrement()).setBody((DisassembleResponse.ResponseBody)body)));
                        break;
                    }
                    default: {
                        this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create().setError(Message.create(1014, "Unrecognized command: {_cmd}").setVariables(Collections.singletonMap("_cmd", command))), seq, false, command, this.sequenceNum.getAndIncrement()).setMessage(DebugProtocolServer.format("Unrecognized command: `%s`", command)));
                    }
                }
                if (future != null) {
                    this.pendingReceivedRequests.put(seq, (CompletableFuture<?>)future);
                    ((CompletableFuture)((CompletableFuture)future).exceptionally(throwable -> {
                        if (this.isCancellationException((Throwable)throwable)) {
                            this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create(), seq, false, command, this.sequenceNum.getAndIncrement()).setMessage("cancelled"));
                        } else if (this.isExceptionWithMessage((Throwable)throwable)) {
                            this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create().setError(this.asExceptionWithMessage((Throwable)throwable).getDebugMessage()), seq, false, command, this.sequenceNum.getAndIncrement()).setMessage(throwable.getMessage()));
                        } else {
                            String msg = throwable.getMessage() != null ? throwable.getMessage() : "";
                            this.server.getLogger().log(Level.SEVERE, msg, (Throwable)throwable);
                            this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create().setError(Message.create(1104, "Internal Error: {_err}").setVariables(Collections.singletonMap("_err", msg))), seq, false, command, this.sequenceNum.getAndIncrement()).setMessage(DebugProtocolServer.format("Internal Error: `%s`", msg)));
                        }
                        return null;
                    })).thenApply(obj -> {
                        this.pendingReceivedRequests.remove(seq);
                        return null;
                    });
                }
            }
            catch (ExceptionWithMessage ewm) {
                this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create().setError(ewm.getDebugMessage()), seq, false, command, this.sequenceNum.getAndIncrement()).setMessage(ewm.getMessage()));
            }
            catch (Exception e) {
                String msg = e.getMessage() != null ? e.getMessage() : "";
                this.server.getLogger().log(Level.SEVERE, msg, e);
                this.sendErrorResponse((ErrorResponse)ErrorResponse.create(ErrorResponse.ResponseBody.create().setError(Message.create(1104, "Internal Error: {_err}").setVariables(Collections.singletonMap("_err", msg))), seq, false, command, this.sequenceNum.getAndIncrement()).setMessage(DebugProtocolServer.format("Internal Error: `%s`", msg)));
            }
        }

        private void processResponse(Response response) {
            CompletableFuture<Response> future = this.pendingSentRequests.remove(response.getRequestSeq());
            if (future != null) {
                try {
                    String command;
                    switch (command = response.getCommand()) {
                        case "runInTerminal": {
                            future.complete(new RunInTerminalResponse(response.jsonData));
                            break;
                        }
                        default: {
                            future.completeExceptionally(new RuntimeException(DebugProtocolServer.format("Unrecognized command: `%s`", command)));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.server.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    future.completeExceptionally(e);
                }
            }
        }

        private CompletableFuture<Response> sendRequest(Request request) {
            CompletableFuture<Response> future = new CompletableFuture<Response>();
            if (this.server.getLogger().isLoggable(Level.FINER)) {
                String format = "[Trace - %s] Sending request '%s - (%d)'\nArgs: %s";
                this.server.getLogger().log(Level.FINER, DebugProtocolServer.format(format, Instant.now().toString(), request.getCommand(), request.getSeq(), Session.getJSONData(request.getArguments())));
            }
            this.writeMessage(Session.getJSONData(request).toString());
            this.pendingSentRequests.put(request.getSeq(), future);
            return future;
        }

        private void sendResponse(Response response) {
            if (this.server.getLogger().isLoggable(Level.FINER)) {
                String format = "[Trace - %s] Sending response '(%d)'\nResult: %s";
                this.server.getLogger().log(Level.FINER, DebugProtocolServer.format(format, Instant.now().toString(), response.getRequestSeq(), Session.getJSONData(response.getBody())));
            }
            this.writeMessage(Session.getJSONData(response).toString());
        }

        private void sendErrorResponse(ErrorResponse response) {
            if (this.server.getLogger().isLoggable(Level.FINER)) {
                String format = "[Trace - %s] Sending error response '(%d)'\nError: %s";
                this.server.getLogger().log(Level.FINER, DebugProtocolServer.format(format, Instant.now().toString(), response.getRequestSeq(), Session.getJSONData(response.getBody().getError())));
            }
            this.writeMessage(Session.getJSONData(response).toString());
        }

        private void sendEvent(Event event) {
            if (this.server.getLogger().isLoggable(Level.FINER)) {
                String format = "[Trace - %s] Sending event '%s'\nBody: %s";
                this.server.getLogger().log(Level.FINER, DebugProtocolServer.format(format, Instant.now().toString(), event.getType(), Session.getJSONData(event.getBody())));
            }
            this.writeMessage(Session.getJSONData(event).toString());
        }

        private void writeMessage(String message) {
            try {
                byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
                Session.writeMessageBytes(this.out, messageBytes);
            }
            catch (IOException ex) {
                this.server.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeMessageBytes(OutputStream out, byte[] messageBytes) throws IOException {
            int contentLength = messageBytes.length;
            String header = DebugProtocolServer.format("Content-Length: %d\r\n\r\n", contentLength);
            byte[] headerBytes = header.getBytes(StandardCharsets.US_ASCII);
            OutputStream outputStream = out;
            synchronized (outputStream) {
                out.write(headerBytes);
                out.write(messageBytes);
                out.flush();
            }
        }

        private static Object getJSONData(Object object) {
            if (object instanceof List) {
                JSONArray json = new JSONArray();
                for (Object obj : (List)object) {
                    json.put(Session.getJSONData(obj));
                }
                return json;
            }
            if (object instanceof JSONBase) {
                return ((JSONBase)object).jsonData;
            }
            return object;
        }

        private boolean isCancellationException(Throwable t) {
            return t instanceof CompletionException ? this.isCancellationException(t.getCause()) : t instanceof CancellationException;
        }

        private boolean isExceptionWithMessage(Throwable t) {
            return t instanceof CompletionException ? this.isExceptionWithMessage(t.getCause()) : t instanceof ExceptionWithMessage;
        }

        private ExceptionWithMessage asExceptionWithMessage(Throwable t) {
            return t instanceof CompletionException ? this.asExceptionWithMessage(t.getCause()) : (t instanceof ExceptionWithMessage ? (ExceptionWithMessage)t : null);
        }

        public static Future<?> connect(DebugProtocolServer server, InputStream in, OutputStream out, ExecutorService executors) {
            Session s = new Session(server, in, out);
            return executors.submit(s);
        }
    }
}

