/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import com.oracle.truffle.tools.dap.types.LoadedSourceEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.graalvm.collections.Pair;

public final class LoadedSourcesHandler
implements LoadSourceListener {
    private final ExecutionContext context;
    private final DebuggerSession debuggerSession;
    private final Map<Source, Integer> sourceIDs = new HashMap<Source, Integer>(100);
    private final List<DAPSourceWrapper> sources = new ArrayList<DAPSourceWrapper>(100);
    private final Map<String, Source> sourcesByPath = new HashMap<String, Source>(100);
    private final Map<String, Consumer<Source>> toRunOnLoad = new HashMap<String, Consumer<Source>>();
    private final Object sourcesLock = this.sourceIDs;

    public LoadedSourcesHandler(ExecutionContext context, DebuggerSession debuggerSession) {
        this.context = context;
        this.debuggerSession = debuggerSession;
    }

    public void onLoad(LoadSourceEvent event) {
        Source source = event.getSource();
        if (this.context.isInspectInternal() || !source.isInternal()) {
            this.assureLoaded(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScriptId(Source source) {
        Object object = this.sourcesLock;
        synchronized (object) {
            Integer id = this.sourceIDs.get(source);
            if (id != null) {
                return id;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getSource(int id) {
        Object object = this.sourcesLock;
        synchronized (object) {
            return this.sources.get((int)(id - 1)).truffleSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getSource(String path) {
        Object object = this.sourcesLock;
        synchronized (object) {
            return this.sourcesByPath.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<com.oracle.truffle.tools.dap.types.Source> getLoadedSources() {
        Object object = this.sourcesLock;
        synchronized (object) {
            int n = this.sources.size();
            com.oracle.truffle.tools.dap.types.Source[] arr = new com.oracle.truffle.tools.dap.types.Source[n];
            for (int i = 0; i < n; ++i) {
                arr[i] = this.sources.get((int)i).dapSource;
            }
            return Collections.unmodifiableList(Arrays.asList(arr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnLoad(String path, Consumer<Source> task) {
        if (path == null) {
            return;
        }
        Object object = this.sourcesLock;
        synchronized (object) {
            Source source = this.getSource(path);
            if (source != null) {
                if (task != null) {
                    task.accept(source);
                }
            } else if (task != null) {
                this.toRunOnLoad.put(path, task);
            } else {
                this.toRunOnLoad.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.oracle.truffle.tools.dap.types.Source assureLoaded(Source sourceLoaded) {
        DebugProtocolClient client;
        com.oracle.truffle.tools.dap.types.Source dapSource;
        Source sourceResolved = this.debuggerSession.resolveSource(sourceLoaded);
        Source source = sourceResolved != null ? sourceResolved : sourceLoaded;
        Consumer<Source> task = null;
        Object object = this.sourcesLock;
        synchronized (object) {
            Integer eid = this.sourceIDs.get(source);
            if (eid != null) {
                return this.sources.get((int)(eid.intValue() - 1)).dapSource;
            }
            int id = this.sources.size() + 1;
            this.sourceIDs.put(source, id);
            dapSource = this.from(source);
            this.sources.add(new DAPSourceWrapper(dapSource, source));
            String path = dapSource.getPath();
            if (path != null) {
                this.sourcesByPath.put(path, source);
                task = this.toRunOnLoad.remove(path);
            }
        }
        if (task != null) {
            task.accept(sourceLoaded);
        }
        if ((client = this.context.getClient()) != null) {
            client.loadedSource(LoadedSourceEvent.EventBody.create("new", dapSource));
        }
        return dapSource;
    }

    private com.oracle.truffle.tools.dap.types.Source from(Source source) {
        if (source == null) {
            return null;
        }
        com.oracle.truffle.tools.dap.types.Source src = com.oracle.truffle.tools.dap.types.Source.create().setName(source.getName());
        Pair<String, Boolean> pathSrcRef = this.getPath(source);
        String path = (String)pathSrcRef.getLeft();
        if (path != null) {
            src.setPath(path);
        }
        if (((Boolean)pathSrcRef.getRight()).booleanValue()) {
            assert (Thread.holdsLock(this.sourcesLock));
            src.setSourceReference(this.sourceIDs.get(source));
        }
        return src;
    }

    private Pair<String, Boolean> getPath(Source source) {
        String path = source.getPath();
        boolean srcRef = path == null;
        TruffleFile tFile = null;
        try {
            if (path == null) {
                URI uri = source.getURI();
                if (uri.isAbsolute()) {
                    tFile = this.context.getEnv().getTruffleFile(uri);
                }
            } else if (!source.getURI().isAbsolute()) {
                tFile = this.context.getEnv().getTruffleFile(path);
            }
        }
        catch (UnsupportedOperationException uri) {
            // empty catch block
        }
        if (tFile != null) {
            try {
                path = tFile.getAbsoluteFile().getPath();
                srcRef = !tFile.isReadable();
            }
            catch (SecurityException uri) {}
        } else if (path != null) {
            try {
                srcRef = !this.context.getEnv().getTruffleFile(path).isReadable();
            }
            catch (SecurityException ex) {
                srcRef = true;
            }
        }
        return Pair.create((Object)path, (Object)srcRef);
    }

    private static final class DAPSourceWrapper {
        final com.oracle.truffle.tools.dap.types.Source dapSource;
        final Source truffleSource;

        DAPSourceWrapper(com.oracle.truffle.tools.dap.types.Source dapSource, Source truffleSource) {
            this.dapSource = dapSource;
            this.truffleSource = truffleSource;
        }
    }
}

