/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class ExitedEvent
extends Event {
    ExitedEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ExitedEvent setBody(EventBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExitedEvent other = (ExitedEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.getEvent());
        hash = 53 * hash + Objects.hashCode(this.getBody());
        hash = 53 * hash + Objects.hashCode(this.getType());
        hash = 53 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ExitedEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "exited");
        json.put("body", body.jsonData);
        json.put("type", "event");
        json.put("seq", seq);
        return new ExitedEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public int getExitCode() {
            return this.jsonData.getInt("exitCode");
        }

        public EventBody setExitCode(int exitCode) {
            this.jsonData.put("exitCode", exitCode);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            return this.getExitCode() == other.getExitCode();
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Integer.hashCode(this.getExitCode());
            return hash;
        }

        public static EventBody create(Integer exitCode) {
            JSONObject json = new JSONObject();
            json.put("exitCode", exitCode);
            return new EventBody(json);
        }
    }
}

