/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.server.ThreadsHandler;
import com.oracle.truffle.tools.dap.server.VariablesHandler;
import com.oracle.truffle.tools.dap.types.Scope;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.dap.types.StackFrame;
import com.oracle.truffle.tools.dap.types.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public final class StackFramesHandler {
    private final ExecutionContext context;
    private final DebuggerSession debuggerSession;

    public StackFramesHandler(ExecutionContext context, DebuggerSession debuggerSession) {
        this.context = context;
        this.debuggerSession = debuggerSession;
    }

    public List<StackFrame> getStackTrace(ThreadsHandler.SuspendedThreadInfo info) {
        ArrayList<StackFrame> sfs = new ArrayList<StackFrame>();
        boolean top = true;
        for (DebugStackFrame frame : info.getSuspendedEvent().getStackFrames()) {
            SourceSection sourceSection = frame.getSourceSection();
            if (sourceSection == null || !sourceSection.isAvailable() || !this.context.isInspectInternal() && frame.isInternal()) continue;
            com.oracle.truffle.api.source.Source source = sourceSection.getSource();
            if (!this.context.isInspectInternal() && source.isInternal()) continue;
            Source dapSource = this.context.getLoadedSourcesHandler().assureLoaded(source);
            SuspendAnchor anchor = SuspendAnchor.BEFORE;
            DebugValue returnValue = null;
            if (top) {
                anchor = info.getSuspendedEvent().getSuspendAnchor();
                if (info.getSuspendedEvent().hasSourceElement(SourceElement.ROOT)) {
                    returnValue = info.getSuspendedEvent().getReturnValue();
                }
            }
            if (anchor == SuspendAnchor.BEFORE) {
                sfs.add(StackFrame.create(info.getId(new FrameWrapper(frame, returnValue)), frame.getName(), this.context.debuggerToClientLine(sourceSection.getStartLine()), this.context.debuggerToClientColumn(sourceSection.getStartColumn())).setSource(dapSource));
            } else {
                sfs.add(StackFrame.create(info.getId(new FrameWrapper(frame, returnValue)), frame.getName(), this.context.debuggerToClientLine(sourceSection.getEndLine()), this.context.debuggerToClientColumn(sourceSection.getEndColumn())).setSource(dapSource));
            }
            top = false;
        }
        return sfs;
    }

    public List<Scope> getScopes(ThreadsHandler.SuspendedThreadInfo info, int frameId) {
        DebugStackFrame frame;
        FrameWrapper frameWrapper = info.getById(FrameWrapper.class, frameId);
        DebugStackFrame debugStackFrame = frame = frameWrapper != null ? frameWrapper.getFrame() : null;
        if (frame != null) {
            DebugScope dscope;
            ArrayList<Scope> scopes;
            block16: {
                scopes = new ArrayList<Scope>();
                try {
                    dscope = frame.getScope();
                }
                catch (DebugException ex) {
                    PrintWriter err = this.context.getErr();
                    if (err != null) {
                        err.println("getScope() has caused " + ex);
                        ex.printStackTrace(err);
                    }
                    dscope = null;
                }
                String scopeName = "Block";
                boolean wasFunction = false;
                ScopeWrapper topScopeWrapper = null;
                DebugValue thisValue = null;
                while (dscope != null) {
                    if (wasFunction) {
                        scopeName = "Closure";
                    } else if (dscope.isFunctionScope()) {
                        scopeName = "Local";
                        thisValue = dscope.getReceiver();
                        wasFunction = true;
                    }
                    if (dscope.isFunctionScope() || dscope.getDeclaredValues().iterator().hasNext()) {
                        if (scopes.isEmpty()) {
                            topScopeWrapper = new ScopeWrapper(frameWrapper, dscope);
                            scopes.add(Scope.create(scopeName, info.getId(topScopeWrapper), false));
                        } else {
                            scopes.add(Scope.create(scopeName, info.getId(new ScopeWrapper(frameWrapper, dscope)), false));
                        }
                    }
                    dscope = this.getParent(dscope);
                }
                if (thisValue != null && topScopeWrapper != null) {
                    topScopeWrapper.thisValue = thisValue;
                }
                try {
                    dscope = this.debuggerSession.getTopScope(frame.getSourceSection().getSource().getLanguage());
                }
                catch (DebugException ex) {
                    PrintWriter err = this.context.getErr();
                    if (err == null) break block16;
                    err.println("getTopScope() has caused " + ex);
                    ex.printStackTrace(err);
                }
            }
            while (dscope != null) {
                if (dscope.isFunctionScope() || dscope.getDeclaredValues().iterator().hasNext()) {
                    scopes.add(Scope.create("Global", info.getId(dscope), true));
                }
                dscope = this.getParent(dscope);
            }
            return scopes;
        }
        return null;
    }

    public static Variable evaluateOnStackFrame(ThreadsHandler.SuspendedThreadInfo info, int frameId, String expression) {
        DebugValue value;
        DebugStackFrame frame;
        FrameWrapper frameWrapper = info.getById(FrameWrapper.class, frameId);
        DebugStackFrame debugStackFrame = frame = frameWrapper != null ? frameWrapper.getFrame() : null;
        if (frame != null && (value = VariablesHandler.getDebugValue(frame, expression)) != null) {
            return VariablesHandler.createVariable(info, value, "");
        }
        return null;
    }

    private DebugScope getParent(DebugScope dscope) {
        DebugScope parentScope;
        try {
            parentScope = dscope.getParent();
        }
        catch (DebugException ex) {
            PrintWriter err = this.context.getErr();
            if (err != null) {
                err.println("Scope.getParent() has caused " + ex);
                ex.printStackTrace(err);
            }
            parentScope = null;
        }
        return parentScope;
    }

    private static final class FrameWrapper {
        private final DebugStackFrame frame;
        private final DebugValue returnValue;

        private FrameWrapper(DebugStackFrame frame, DebugValue returnValue) {
            this.frame = frame;
            this.returnValue = returnValue;
        }

        public DebugValue getReturnValue() {
            return this.returnValue;
        }

        public DebugStackFrame getFrame() {
            return this.frame;
        }
    }

    static final class ScopeWrapper {
        private final FrameWrapper frame;
        private final DebugScope scope;
        private DebugValue thisValue;

        private ScopeWrapper(FrameWrapper frame, DebugScope scope) {
            this.frame = frame;
            this.scope = scope;
        }

        public DebugValue getThisValue() {
            return this.thisValue;
        }

        public DebugValue getReturnValue() {
            return this.frame.getReturnValue();
        }

        public DebugStackFrame getFrame() {
            return this.frame.getFrame();
        }

        public DebugScope getScope() {
            return this.scope;
        }
    }
}

