/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.dap.server.BreakpointsHandler;
import com.oracle.truffle.tools.dap.server.LoadedSourcesHandler;
import com.oracle.truffle.tools.dap.server.StackFramesHandler;
import com.oracle.truffle.tools.dap.server.ThreadsHandler;
import com.oracle.truffle.tools.dap.server.VariablesHandler;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import java.io.PrintWriter;

public final class ExecutionContext {
    private final TruffleInstrument.Env env;
    private final PrintWriter info;
    private final PrintWriter err;
    private final boolean inspectInternal;
    private final boolean inspectInitialization;
    private final TruffleLogger logger;
    private final boolean[] runPermission = new boolean[]{false};
    private volatile DebugProtocolClient client;
    private volatile LoadedSourcesHandler loadedSourcesHandler;
    private volatile EventBinding<LoadSourceListener> srcBinding;
    private volatile ThreadsHandler threadsHandler;
    private volatile EventBinding<ThreadsListener> thrBinding;
    private volatile BreakpointsHandler breakpointsHandler;
    private volatile StackFramesHandler stackFramesHandler;
    private volatile VariablesHandler variablesHandler;
    private boolean linesStartAt1 = true;
    private boolean columnsStartAt1 = true;

    public ExecutionContext(TruffleInstrument.Env env, PrintWriter info, PrintWriter err, boolean inspectInternal, boolean inspectInitialization) {
        this.env = env;
        this.err = err;
        this.info = info;
        this.inspectInternal = inspectInternal;
        this.inspectInitialization = inspectInitialization;
        this.logger = env.getLogger("");
    }

    public void initSession(DebuggerSession debuggerSession) {
        this.loadedSourcesHandler = new LoadedSourcesHandler(this, debuggerSession);
        this.srcBinding = this.env.getInstrumenter().attachLoadSourceListener(SourceFilter.ANY, (LoadSourceListener)this.loadedSourcesHandler, true);
        this.threadsHandler = new ThreadsHandler(this, debuggerSession);
        this.thrBinding = this.env.getInstrumenter().attachThreadsListener((ThreadsListener)this.threadsHandler, true);
        this.breakpointsHandler = new BreakpointsHandler(this, debuggerSession);
        this.stackFramesHandler = new StackFramesHandler(this, debuggerSession);
        this.variablesHandler = new VariablesHandler(this);
    }

    public void initClient(DebugProtocolClient dpClient) {
        this.client = dpClient;
    }

    public TruffleInstrument.Env getEnv() {
        return this.env;
    }

    public PrintWriter getInfo() {
        return this.info;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public boolean isInspectInternal() {
        return this.inspectInternal;
    }

    public boolean isInspectInitialization() {
        return this.inspectInitialization;
    }

    public TruffleLogger getLogger() {
        return this.logger;
    }

    public DebugProtocolClient getClient() {
        return this.client;
    }

    public LoadedSourcesHandler getLoadedSourcesHandler() {
        return this.loadedSourcesHandler;
    }

    public ThreadsHandler getThreadsHandler() {
        return this.threadsHandler;
    }

    public BreakpointsHandler getBreakpointsHandler() {
        return this.breakpointsHandler;
    }

    public VariablesHandler getVariablesHandler() {
        return this.variablesHandler;
    }

    public StackFramesHandler getStackFramesHandler() {
        return this.stackFramesHandler;
    }

    public void setLinesStartAt1(Boolean value) {
        if (value != null && !value.booleanValue()) {
            this.linesStartAt1 = false;
        }
    }

    void setColumnsStartAt1(Boolean value) {
        if (value != null && !value.booleanValue()) {
            this.columnsStartAt1 = false;
        }
    }

    public int clientToDebuggerLine(int line) {
        return this.linesStartAt1 ? line : line + 1;
    }

    public int clientToDebuggerColumn(int col) {
        return this.columnsStartAt1 ? col : col + 1;
    }

    public int debuggerToClientLine(int line) {
        return this.linesStartAt1 ? line : line - 1;
    }

    public int debuggerToClientColumn(int col) {
        return this.columnsStartAt1 ? col : col - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRunIfWaitingForDebugger() {
        boolean[] blArray = this.runPermission;
        synchronized (this.runPermission) {
            this.runPermission[0] = true;
            this.runPermission.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRunPermission() throws InterruptedException {
        boolean[] blArray = this.runPermission;
        synchronized (this.runPermission) {
            while (!this.runPermission[0]) {
                this.runPermission.wait();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void dispose() {
        if (this.srcBinding != null && !this.srcBinding.isDisposed()) {
            this.srcBinding.dispose();
        }
        if (this.thrBinding != null && !this.thrBinding.isDisposed()) {
            this.thrBinding.dispose();
        }
        if (this.threadsHandler != null) {
            this.threadsHandler.dispose();
        }
        this.doRunIfWaitingForDebugger();
    }
}

