/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.VariablePresentationHint;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Variable
extends JSONBase {
    Variable(JSONObject jsonData) {
        super(jsonData);
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public Variable setName(String name) {
        this.jsonData.put("name", name);
        return this;
    }

    public String getValue() {
        return this.jsonData.getString("value");
    }

    public Variable setValue(String value) {
        this.jsonData.put("value", value);
        return this;
    }

    public String getType() {
        return this.jsonData.optString("type", null);
    }

    public Variable setType(String type) {
        this.jsonData.putOpt("type", type);
        return this;
    }

    public VariablePresentationHint getPresentationHint() {
        return this.jsonData.has("presentationHint") ? new VariablePresentationHint(this.jsonData.optJSONObject("presentationHint")) : null;
    }

    public Variable setPresentationHint(VariablePresentationHint presentationHint) {
        this.jsonData.putOpt("presentationHint", presentationHint != null ? presentationHint.jsonData : null);
        return this;
    }

    public String getEvaluateName() {
        return this.jsonData.optString("evaluateName", null);
    }

    public Variable setEvaluateName(String evaluateName) {
        this.jsonData.putOpt("evaluateName", evaluateName);
        return this;
    }

    public int getVariablesReference() {
        return this.jsonData.getInt("variablesReference");
    }

    public Variable setVariablesReference(int variablesReference) {
        this.jsonData.put("variablesReference", variablesReference);
        return this;
    }

    public Integer getNamedVariables() {
        return this.jsonData.has("namedVariables") ? Integer.valueOf(this.jsonData.getInt("namedVariables")) : null;
    }

    public Variable setNamedVariables(Integer namedVariables) {
        this.jsonData.putOpt("namedVariables", namedVariables);
        return this;
    }

    public Integer getIndexedVariables() {
        return this.jsonData.has("indexedVariables") ? Integer.valueOf(this.jsonData.getInt("indexedVariables")) : null;
    }

    public Variable setIndexedVariables(Integer indexedVariables) {
        this.jsonData.putOpt("indexedVariables", indexedVariables);
        return this;
    }

    public String getMemoryReference() {
        return this.jsonData.optString("memoryReference", null);
    }

    public Variable setMemoryReference(String memoryReference) {
        this.jsonData.putOpt("memoryReference", memoryReference);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getValue(), other.getValue())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equals(this.getPresentationHint(), other.getPresentationHint())) {
            return false;
        }
        if (!Objects.equals(this.getEvaluateName(), other.getEvaluateName())) {
            return false;
        }
        if (this.getVariablesReference() != other.getVariablesReference()) {
            return false;
        }
        if (!Objects.equals(this.getNamedVariables(), other.getNamedVariables())) {
            return false;
        }
        if (!Objects.equals(this.getIndexedVariables(), other.getIndexedVariables())) {
            return false;
        }
        return Objects.equals(this.getMemoryReference(), other.getMemoryReference());
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.getName());
        hash = 29 * hash + Objects.hashCode(this.getValue());
        if (this.getType() != null) {
            hash = 29 * hash + Objects.hashCode(this.getType());
        }
        if (this.getPresentationHint() != null) {
            hash = 29 * hash + Objects.hashCode(this.getPresentationHint());
        }
        if (this.getEvaluateName() != null) {
            hash = 29 * hash + Objects.hashCode(this.getEvaluateName());
        }
        hash = 29 * hash + Integer.hashCode(this.getVariablesReference());
        if (this.getNamedVariables() != null) {
            hash = 29 * hash + Integer.hashCode(this.getNamedVariables());
        }
        if (this.getIndexedVariables() != null) {
            hash = 29 * hash + Integer.hashCode(this.getIndexedVariables());
        }
        if (this.getMemoryReference() != null) {
            hash = 29 * hash + Objects.hashCode(this.getMemoryReference());
        }
        return hash;
    }

    public static Variable create(String name, String value, Integer variablesReference) {
        JSONObject json = new JSONObject();
        json.put("name", name);
        json.put("value", value);
        json.put("variablesReference", variablesReference);
        return new Variable(json);
    }
}

