/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.Variable;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VariablesResponse
extends Response {
    VariablesResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public VariablesResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariablesResponse other = (VariablesResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getBody());
        hash = 89 * hash + Objects.hashCode(this.getType());
        hash = 89 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 89 * hash + Boolean.hashCode(this.isSuccess());
        hash = 89 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 89 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 89 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static VariablesResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new VariablesResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<Variable> getVariables() {
            JSONArray json = this.jsonData.getJSONArray("variables");
            ArrayList<Variable> list = new ArrayList<Variable>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new Variable(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setVariables(List<Variable> variables) {
            JSONArray json = new JSONArray();
            for (Variable variable : variables) {
                json.put(variable.jsonData);
            }
            this.jsonData.put("variables", json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getVariables(), other.getVariables());
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.getVariables());
            return hash;
        }

        public static ResponseBody create(List<Variable> variables) {
            JSONObject json = new JSONObject();
            JSONArray variablesJsonArr = new JSONArray();
            for (Variable variable : variables) {
                variablesJsonArr.put(variable.jsonData);
            }
            json.put("variables", variablesJsonArr);
            return new ResponseBody(json);
        }
    }
}

