/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TerminateThreadsArguments
extends JSONBase {
    TerminateThreadsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Integer> getThreadIds() {
        JSONArray json = this.jsonData.optJSONArray("threadIds");
        if (json == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getInt(i));
        }
        return Collections.unmodifiableList(list);
    }

    public TerminateThreadsArguments setThreadIds(List<Integer> threadIds) {
        if (threadIds != null) {
            JSONArray json = new JSONArray();
            for (int intValue : threadIds) {
                json.put(intValue);
            }
            this.jsonData.put("threadIds", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminateThreadsArguments other = (TerminateThreadsArguments)obj;
        return Objects.equals(this.getThreadIds(), other.getThreadIds());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getThreadIds() != null) {
            hash = 79 * hash + Objects.hashCode(this.getThreadIds());
        }
        return hash;
    }

    public static TerminateThreadsArguments create() {
        JSONObject json = new JSONObject();
        return new TerminateThreadsArguments(json);
    }
}

