/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ProtocolMessage;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Event
extends ProtocolMessage {
    Event(JSONObject jsonData) {
        super(jsonData);
    }

    public String getEvent() {
        return this.jsonData.getString("event");
    }

    public Event setEvent(String event) {
        this.jsonData.put("event", event);
        return this;
    }

    public Object getBody() {
        return this.jsonData.opt("body");
    }

    public Event setBody(Object body) {
        this.jsonData.putOpt("body", body);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.getType());
        hash = 83 * hash + Objects.hashCode(this.getEvent());
        if (this.getBody() != null) {
            hash = 83 * hash + Objects.hashCode(this.getBody());
        }
        hash = 83 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static Event create(String event, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("type", "event");
        json.put("event", event);
        json.put("seq", seq);
        return new Event(json);
    }
}

