/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Checksum
extends JSONBase {
    Checksum(JSONObject jsonData) {
        super(jsonData);
    }

    public String getAlgorithm() {
        return this.jsonData.getString("algorithm");
    }

    public Checksum setAlgorithm(String algorithm) {
        this.jsonData.put("algorithm", algorithm);
        return this;
    }

    public String getChecksum() {
        return this.jsonData.getString("checksum");
    }

    public Checksum setChecksum(String checksum) {
        this.jsonData.put("checksum", checksum);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Checksum other = (Checksum)obj;
        if (!Objects.equals(this.getAlgorithm(), other.getAlgorithm())) {
            return false;
        }
        return Objects.equals(this.getChecksum(), other.getChecksum());
    }

    public int hashCode() {
        int hash = 2;
        hash = 29 * hash + Objects.hashCode(this.getAlgorithm());
        hash = 29 * hash + Objects.hashCode(this.getChecksum());
        return hash;
    }

    public static Checksum create(String algorithm, String checksum) {
        JSONObject json = new JSONObject();
        json.put("algorithm", algorithm);
        json.put("checksum", checksum);
        return new Checksum(json);
    }
}

