/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ExceptionPathSegment;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ExceptionOptions
extends JSONBase {
    ExceptionOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<ExceptionPathSegment> getPath() {
        JSONArray json = this.jsonData.optJSONArray("path");
        if (json == null) {
            return null;
        }
        ArrayList<ExceptionPathSegment> list = new ArrayList<ExceptionPathSegment>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ExceptionPathSegment(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public ExceptionOptions setPath(List<ExceptionPathSegment> path) {
        if (path != null) {
            JSONArray json = new JSONArray();
            for (ExceptionPathSegment exceptionPathSegment : path) {
                json.put(exceptionPathSegment.jsonData);
            }
            this.jsonData.put("path", json);
        }
        return this;
    }

    public String getBreakMode() {
        return this.jsonData.getString("breakMode");
    }

    public ExceptionOptions setBreakMode(String breakMode) {
        this.jsonData.put("breakMode", breakMode);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionOptions other = (ExceptionOptions)obj;
        if (!Objects.equals(this.getPath(), other.getPath())) {
            return false;
        }
        return Objects.equals(this.getBreakMode(), other.getBreakMode());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getPath() != null) {
            hash = 11 * hash + Objects.hashCode(this.getPath());
        }
        hash = 11 * hash + Objects.hashCode(this.getBreakMode());
        return hash;
    }

    public static ExceptionOptions create(String breakMode) {
        JSONObject json = new JSONObject();
        json.put("breakMode", breakMode);
        return new ExceptionOptions(json);
    }
}

