/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Breakpoint;
import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class BreakpointEvent
extends Event {
    BreakpointEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public BreakpointEvent setBody(EventBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointEvent other = (BreakpointEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getEvent());
        hash = 59 * hash + Objects.hashCode(this.getBody());
        hash = 59 * hash + Objects.hashCode(this.getType());
        hash = 59 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static BreakpointEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "breakpoint");
        json.put("body", body.jsonData);
        json.put("type", "event");
        json.put("seq", seq);
        return new BreakpointEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getReason() {
            return this.jsonData.getString("reason");
        }

        public EventBody setReason(String reason) {
            this.jsonData.put("reason", reason);
            return this;
        }

        public Breakpoint getBreakpoint() {
            return new Breakpoint(this.jsonData.getJSONObject("breakpoint"));
        }

        public EventBody setBreakpoint(Breakpoint breakpoint) {
            this.jsonData.put("breakpoint", breakpoint.jsonData);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getReason(), other.getReason())) {
                return false;
            }
            return Objects.equals(this.getBreakpoint(), other.getBreakpoint());
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + Objects.hashCode(this.getReason());
            hash = 59 * hash + Objects.hashCode(this.getBreakpoint());
            return hash;
        }

        public static EventBody create(String reason, Breakpoint breakpoint) {
            JSONObject json = new JSONObject();
            json.put("reason", reason);
            json.put("breakpoint", breakpoint.jsonData);
            return new EventBody(json);
        }
    }
}

