/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class RunInTerminalResponse
extends Response {
    RunInTerminalResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public RunInTerminalResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunInTerminalResponse other = (RunInTerminalResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.getBody());
        hash = 13 * hash + Objects.hashCode(this.getType());
        hash = 13 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 13 * hash + Boolean.hashCode(this.isSuccess());
        hash = 13 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 13 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 13 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static RunInTerminalResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new RunInTerminalResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public Integer getProcessId() {
            return this.jsonData.has("processId") ? Integer.valueOf(this.jsonData.getInt("processId")) : null;
        }

        public ResponseBody setProcessId(Integer processId) {
            this.jsonData.putOpt("processId", processId);
            return this;
        }

        public Integer getShellProcessId() {
            return this.jsonData.has("shellProcessId") ? Integer.valueOf(this.jsonData.getInt("shellProcessId")) : null;
        }

        public ResponseBody setShellProcessId(Integer shellProcessId) {
            this.jsonData.putOpt("shellProcessId", shellProcessId);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getProcessId(), other.getProcessId())) {
                return false;
            }
            return Objects.equals(this.getShellProcessId(), other.getShellProcessId());
        }

        public int hashCode() {
            int hash = 3;
            if (this.getProcessId() != null) {
                hash = 29 * hash + Integer.hashCode(this.getProcessId());
            }
            if (this.getShellProcessId() != null) {
                hash = 29 * hash + Integer.hashCode(this.getShellProcessId());
            }
            return hash;
        }

        public static ResponseBody create() {
            JSONObject json = new JSONObject();
            return new ResponseBody(json);
        }
    }
}

